/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::Register_translation_unit_Glue"
  Register_translation_unit_Glue::Register_translation_unit_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_translation_unit_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"Begin");

    log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Method - genMealy_retire");

	SC_METHOD (genMealy_retire);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  sensitive << (*(in_RETIRE_VAL           [i]))
		    << (*(in_RETIRE_RAT_ACK       [i]))
		    << (*(in_RETIRE_STAT_LIST_ACK [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  {
	    (*(out_RETIRE_ACK           [i])) (*(in_RETIRE_RAT_ACK       [i]));
	    (*(out_RETIRE_ACK           [i])) (*(in_RETIRE_STAT_LIST_ACK [i]));

	    (*(out_RETIRE_RAT_VAL       [i])) (*(in_RETIRE_VAL           [i]));
	    (*(out_RETIRE_RAT_VAL       [i])) (*(in_RETIRE_STAT_LIST_ACK [i]));

	    (*(out_RETIRE_STAT_LIST_VAL [i])) (*(in_RETIRE_VAL           [i]));
	    (*(out_RETIRE_STAT_LIST_VAL [i])) (*(in_RETIRE_RAT_ACK       [i]));
	  }
# endif    

	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Method - genMealy_insert");

	SC_METHOD (genMealy_insert);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  sensitive << (*(in_INSERT_RENAME_VAL     [i]))
		    << (*(in_INSERT_INSERT_ACK     [i]))
		    << (*(in_INSERT_RAT_RENAME_ACK [i]))
		    << (*(in_INSERT_RAT_INSERT_ACK [i]))
		    << (*(in_INSERT_FREE_LIST_ACK  [i]))
		    << (*(in_INSERT_STAT_LIST_ACK  [i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  {
	    (*(out_INSERT_RENAME_ACK     [i])) (*(in_INSERT_INSERT_ACK     [i]));
	    (*(out_INSERT_RENAME_ACK     [i])) (*(in_INSERT_RAT_RENAME_ACK [i]));
	    (*(out_INSERT_RENAME_ACK     [i])) (*(in_INSERT_RAT_INSERT_ACK [i]));
	    (*(out_INSERT_RENAME_ACK     [i])) (*(in_INSERT_FREE_LIST_ACK  [i]));
	    (*(out_INSERT_RENAME_ACK     [i])) (*(in_INSERT_STAT_LIST_ACK  [i]));

	    (*(out_INSERT_INSERT_VAL     [i])) (*(in_INSERT_RENAME_VAL     [i]));
	    (*(out_INSERT_INSERT_VAL     [i])) (*(in_INSERT_RAT_RENAME_ACK [i]));
	    (*(out_INSERT_INSERT_VAL     [i])) (*(in_INSERT_RAT_INSERT_ACK [i]));
	    (*(out_INSERT_INSERT_VAL     [i])) (*(in_INSERT_FREE_LIST_ACK  [i]));
	    (*(out_INSERT_INSERT_VAL     [i])) (*(in_INSERT_STAT_LIST_ACK  [i]));

	    (*(out_INSERT_RAT_INSERT_VAL [i])) (*(in_INSERT_RENAME_VAL     [i]));
	    (*(out_INSERT_RAT_INSERT_VAL [i])) (*(in_INSERT_INSERT_ACK     [i]));
	    (*(out_INSERT_RAT_INSERT_VAL [i])) (*(in_INSERT_RAT_RENAME_ACK [i]));
	    (*(out_INSERT_RAT_INSERT_VAL [i])) (*(in_INSERT_FREE_LIST_ACK  [i]));
	    (*(out_INSERT_RAT_INSERT_VAL [i])) (*(in_INSERT_STAT_LIST_ACK  [i]));

	    (*(out_INSERT_FREE_LIST_VAL  [i])) (*(in_INSERT_RENAME_VAL     [i]));
	    (*(out_INSERT_FREE_LIST_VAL  [i])) (*(in_INSERT_INSERT_ACK     [i]));
	    (*(out_INSERT_FREE_LIST_VAL  [i])) (*(in_INSERT_RAT_RENAME_ACK [i]));
	    (*(out_INSERT_FREE_LIST_VAL  [i])) (*(in_INSERT_RAT_INSERT_ACK [i]));
	    (*(out_INSERT_FREE_LIST_VAL  [i])) (*(in_INSERT_STAT_LIST_ACK  [i]));

	    (*(out_INSERT_STAT_LIST_VAL  [i])) (*(in_INSERT_RENAME_VAL     [i]));
	    (*(out_INSERT_STAT_LIST_VAL  [i])) (*(in_INSERT_INSERT_ACK     [i]));
	    (*(out_INSERT_STAT_LIST_VAL  [i])) (*(in_INSERT_RAT_RENAME_ACK [i]));
	    (*(out_INSERT_STAT_LIST_VAL  [i])) (*(in_INSERT_RAT_INSERT_ACK [i]));
	    (*(out_INSERT_STAT_LIST_VAL  [i])) (*(in_INSERT_FREE_LIST_ACK  [i]));
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::~Register_translation_unit_Glue"
  Register_translation_unit_Glue::~Register_translation_unit_Glue (void)
  {
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Register_translation_unit_Glue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
