/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/SelfTest/include/test.h"

#define NB_PARAMS 11

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_write_queue    (uint32_t)\n"));
  err (_(" * size_execute_queue  (uint32_t)\n"));
  err (_(" * nb_context          (uint32_t)\n"));
  err (_(" * nb_front_end        (uint32_t)\n"));
  err (_(" * nb_ooo_engine       (uint32_t)\n"));
  err (_(" * nb_packet           (uint32_t)\n"));
  err (_(" * size_general_data   (uint32_t)\n"));
  err (_(" * nb_general_register (uint32_t)\n"));
  err (_(" * size_special_data   (uint32_t)\n"));
  err (_(" * nb_special_register (uint32_t)\n"));
  err (_(" * nb_bypass_write     (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name                =      argv[x++];
  const uint32_t size_write_queue    = atoi(argv[x++]);
  const uint32_t size_execute_queue  = atoi(argv[x++]);
  const uint32_t nb_context          = atoi(argv[x++]);
  const uint32_t nb_front_end        = atoi(argv[x++]);
  const uint32_t nb_ooo_engine       = atoi(argv[x++]);
  const uint32_t nb_packet           = atoi(argv[x++]);
  const uint32_t size_general_data   = atoi(argv[x++]);
  const uint32_t nb_general_register = atoi(argv[x++]);
  const uint32_t size_special_data   = atoi(argv[x++]);
  const uint32_t nb_special_register = atoi(argv[x++]);
  const uint32_t nb_bypass_write     = atoi(argv[x++]);

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Parameters
	(size_write_queue   ,
	 size_execute_queue ,
	 nb_context         ,
	 nb_front_end       ,
	 nb_ooo_engine      ,
	 nb_packet          ,
	 size_general_data  ,
	 nb_general_register,
	 size_special_data  ,
	 nb_special_register,
	 nb_bypass_write    );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

