/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)


  class entry_t
  {
  public : Tcontrol_t          _val             ;
  public : Tcontext_t          _context         ;
  public : Tcontrol_t          _address_dest_val;
  public : Tgeneral_data_t     _address_src     ;
  public : Tgeneral_data_t     _address_dest    ;
  public : Tbranch_condition_t _condition       ;
  public : Tcontrol_t          _last_take       ;
  public : Tcounter_t          _accurate        ;

  public : bool hit (morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param,
		     Tgeneral_data_t addr_test,
		     Tcontext_t      context)
    {
      Tgeneral_data_t addr_src_offset  = (_address_src  >> _param->_shift_offset)&_param->_mask_offset;
      Tgeneral_data_t addr_src_index   = (_address_src  >> _param->_shift_bank  )&_param->_mask_bank  ;
      Tgeneral_data_t addr_src_tag     = (_address_src  >> _param->_shift_tag   );
      
      Tgeneral_data_t addr_test_offset = (addr_test >> _param->_shift_offset)&_param->_mask_offset;
      Tgeneral_data_t addr_test_index  = (addr_test >> _param->_shift_bank  )&_param->_mask_bank  ;
      Tgeneral_data_t addr_test_tag    = (addr_test >> _param->_shift_tag   );

      bool is_hit = ( (_val             == 1               ) and
		      (_context         == context         ) and
		      (addr_test_tag    == addr_src_tag    ) and
		      (addr_test_index  == addr_src_index  ) and
		      (addr_test_offset <= addr_src_offset ));

      LABEL("address_src  (tag, index, offset) : %.8x %.8x %.8x",addr_src_tag, addr_src_index, addr_src_offset);
      LABEL("address_test (tag, index, offset) : %.8x %.8x %.8x - hit : %d",addr_test_tag, addr_test_index, addr_test_offset, is_hit);
      return is_hit;
    }
    
  public : void print (void)
    {
      LABEL("%d - %.2d %.8x %.1d %.8x %.3d %.1d %.4d", 
	    _val             ,
	    _context         ,
	    _address_src     ,
	    _address_dest_val,
	    _address_dest    ,
	    _condition       ,
	    _last_take       ,
	    _accurate        );

    }
    
  };



Tgeneral_data_t gen_addr (morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param,
			  Tgeneral_data_t index)
{
  Tgeneral_data_t addr_tag     = (rand()%(2*_param->_associativity)) << _param->_shift_tag   ;
  Tgeneral_data_t addr_index   = (index &_param->_mask_bank        ) << _param->_shift_bank  ;
  Tgeneral_data_t addr_offset  = (rand()&_param->_mask_offset      ) << _param->_shift_offset;

  LABEL("gen_addr     (tag, index, offset) : %.8x %.8x %.8x",addr_tag, addr_index, addr_offset);

  return (addr_tag    |
	  addr_index  |
	  addr_offset );
}


void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Branch_Target_Buffer_Register * _Branch_Target_Buffer_Register = new Branch_Target_Buffer_Register (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL           ," in_PREDICT_VAL           ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK           ,"out_PREDICT_ACK           ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_CONTEXT_ID    ," in_PREDICT_CONTEXT_ID    ",Tcontext_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_ADDRESS       ," in_PREDICT_ADDRESS       ",Tgeneral_data_t    ,_param->_nb_inst_predict);
  ALLOC2_SC_SIGNAL(out_PREDICT_HIT           ,"out_PREDICT_HIT           ",Tcontrol_t         ,_param->_nb_inst_predict,_param->_associativity);
  ALLOC2_SC_SIGNAL(out_PREDICT_ADDRESS_SRC   ,"out_PREDICT_ADDRESS_SRC   ",Tgeneral_data_t    ,_param->_nb_inst_predict,_param->_associativity);
  ALLOC2_SC_SIGNAL(out_PREDICT_ADDRESS_DEST  ,"out_PREDICT_ADDRESS_DEST  ",Tgeneral_data_t    ,_param->_nb_inst_predict,_param->_associativity);
  ALLOC2_SC_SIGNAL(out_PREDICT_CONDITION     ,"out_PREDICT_CONDITION     ",Tbranch_condition_t,_param->_nb_inst_predict,_param->_associativity);
  ALLOC2_SC_SIGNAL(out_PREDICT_LAST_TAKE     ,"out_PREDICT_LAST_TAKE     ",Tcontrol_t         ,_param->_nb_inst_predict,_param->_associativity);
  ALLOC2_SC_SIGNAL(out_PREDICT_IS_ACCURATE   ,"out_PREDICT_IS_ACCURATE   ",Tcontrol_t         ,_param->_nb_inst_predict,_param->_associativity);
  ALLOC1_SC_SIGNAL( in_DECOD_VAL             ," in_DECOD_VAL             ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ACK             ,"out_DECOD_ACK             ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HIT             ,"out_DECOD_HIT             ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HIT_INDEX       ,"out_DECOD_HIT_INDEX       ",Tptr_t             ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_VICTIM          ," in_DECOD_VICTIM          ",Tptr_t             ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONTEXT_ID      ," in_DECOD_CONTEXT_ID      ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ADDRESS_SRC     ," in_DECOD_ADDRESS_SRC     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ADDRESS_DEST    ," in_DECOD_ADDRESS_DEST    ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONDITION       ," in_DECOD_CONDITION       ",Tbranch_condition_t,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_LAST_TAKE       ," in_DECOD_LAST_TAKE       ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_MISS_PREDICTION ," in_DECOD_MISS_PREDICTION ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_UPDATE_VAL            ," in_UPDATE_VAL            ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_ACK            ,"out_UPDATE_ACK            ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_HIT            ,"out_UPDATE_HIT            ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_HIT_INDEX      ,"out_UPDATE_HIT_INDEX      ",Tptr_t             ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_VICTIM         ," in_UPDATE_VICTIM         ",Tptr_t             ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_CONTEXT_ID     ," in_UPDATE_CONTEXT_ID     ",Tcontext_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ADDRESS_SRC    ," in_UPDATE_ADDRESS_SRC    ",Tgeneral_data_t    ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ADDRESS_DEST   ," in_UPDATE_ADDRESS_DEST   ",Tgeneral_data_t    ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_CONDITION      ," in_UPDATE_CONDITION      ",Tbranch_condition_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_LAST_TAKE      ," in_UPDATE_LAST_TAKE      ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_MISS_PREDICTION," in_UPDATE_MISS_PREDICTION",Tcontrol_t         ,_param->_nb_inst_update);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Branch_Target_Buffer_Register.\n"),name.c_str());

  (*(_Branch_Target_Buffer_Register->in_CLOCK))        (*(in_CLOCK));
  (*(_Branch_Target_Buffer_Register->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_PREDICT_VAL           ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_ACK           ,_param->_nb_inst_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_PREDICT_CONTEXT_ID    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_PREDICT_ADDRESS       ,_param->_nb_inst_predict);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_HIT           ,_param->_nb_inst_predict,_param->_associativity);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_ADDRESS_SRC   ,_param->_nb_inst_predict,_param->_associativity);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_ADDRESS_DEST  ,_param->_nb_inst_predict,_param->_associativity);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_CONDITION     ,_param->_nb_inst_predict,_param->_associativity);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_LAST_TAKE     ,_param->_nb_inst_predict,_param->_associativity);
  INSTANCE2_SC_SIGNAL(_Branch_Target_Buffer_Register,out_PREDICT_IS_ACCURATE   ,_param->_nb_inst_predict,_param->_associativity);

  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_VAL             ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_DECOD_ACK             ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_DECOD_HIT             ,_param->_nb_inst_decod);
  if (_param->_have_port_victim)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_DECOD_HIT_INDEX       ,_param->_nb_inst_decod);
  if (_param->_have_port_victim)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_VICTIM          ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_CONTEXT_ID      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_ADDRESS_SRC     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_ADDRESS_DEST    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_CONDITION       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_LAST_TAKE       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_DECOD_MISS_PREDICTION ,_param->_nb_inst_decod);

  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_VAL            ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_UPDATE_ACK            ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_UPDATE_HIT            ,_param->_nb_inst_update);
  if (_param->_have_port_victim)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register,out_UPDATE_HIT_INDEX      ,_param->_nb_inst_update);
  if (_param->_have_port_victim)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_VICTIM         ,_param->_nb_inst_update);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_CONTEXT_ID     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_ADDRESS_SRC    ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_ADDRESS_DEST   ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_CONDITION      ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_LAST_TAKE      ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer_Register, in_UPDATE_MISS_PREDICTION,_param->_nb_inst_update);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_predict = 75;
  const  int32_t percent_transaction_decod   = 75;
  const  int32_t percent_transaction_update  = 75;

  uint32_t num_index = 0;
  entry_t tab_old [_param->_associativity];
  entry_t tab     [_param->_associativity];

  for (uint32_t i=0; i<_param->_associativity; i++)
    tab[i]._val = false;

  SC_START(0);
  LABEL("Initialisation");

  for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
    in_PREDICT_VAL [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_inst_decod  ; i++)
    in_DECOD_VAL   [i]->write(0);
  for (uint32_t i=0; i<_param->_nb_inst_update ; i++)
    in_UPDATE_VAL  [i]->write(0);

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t j=0; j<_param->_associativity; j++)
	tab[j].print();
      
      for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	{
	  Tgeneral_data_t addr;
	  uint32_t j = rand()%_param->_associativity;

	  if ( ((rand()%100)<percent_transaction_predict) and
	       tab [j]._val)
	    addr = tab [j]._address_src;
	  else
	    addr = gen_addr(_param, num_index);

	  in_PREDICT_VAL        [i]->write((rand()%100)<percent_transaction_predict);
	  in_PREDICT_CONTEXT_ID [i]->write(rand()%_param->_nb_context);
	  in_PREDICT_ADDRESS    [i]->write(addr);
	}

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  Tgeneral_data_t addr = gen_addr(_param, num_index);

	  in_DECOD_VAL             [i]->write((rand()%100)<percent_transaction_decod);
	  in_DECOD_VICTIM          [i]->write(rand()%_param->_associativity);
	  in_DECOD_CONTEXT_ID      [i]->write(rand()%_param->_nb_context);
	  in_DECOD_ADDRESS_SRC     [i]->write(addr);
	  in_DECOD_ADDRESS_DEST    [i]->write(~addr);
	  in_DECOD_CONDITION       [i]->write((addr&1)?BRANCH_CONDITION_FLAG_SET:BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK);
	  in_DECOD_LAST_TAKE       [i]->write(rand()%2);
	  in_DECOD_MISS_PREDICTION [i]->write(rand()%2);
	}

      for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	{
	  Tgeneral_data_t addr = gen_addr(_param, num_index);

	  in_UPDATE_VAL             [i]->write((rand()%100)<percent_transaction_update);
	  in_UPDATE_VICTIM          [i]->write(rand()%_param->_associativity);
	  in_UPDATE_CONTEXT_ID      [i]->write(rand()%_param->_nb_context);
	  in_UPDATE_ADDRESS_SRC     [i]->write(addr);
	  in_UPDATE_ADDRESS_DEST    [i]->write(~addr);
	  in_UPDATE_CONDITION       [i]->write((addr&1)?BRANCH_CONDITION_FLAG_SET:BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK);
	  in_UPDATE_LAST_TAKE       [i]->write(rand()%2);
	  in_UPDATE_MISS_PREDICTION [i]->write(rand()%2);
	}

      SC_START(0);

      for (uint32_t i=0; i<_param->_associativity; i++)
	tab_old [i] = tab [i];

      for (uint32_t i=0; i<_param->_nb_inst_predict  ; i++)
	if (in_PREDICT_VAL [i]->read() and out_PREDICT_ACK [i]->read())
	  {
	    LABEL("PREDICT   [%d] : Transaction accepted",i);
	    LABEL("  * context     : %d"  ,in_PREDICT_CONTEXT_ID [i]->read());
	    LABEL("  * address     : %.8x",in_PREDICT_ADDRESS    [i]->read());

	    Tcontext_t      ctxt = in_PREDICT_CONTEXT_ID [i]->read();
	    Tgeneral_data_t addr = in_PREDICT_ADDRESS [i]->read();

	    for (uint32_t j=0; j<_param->_associativity; j++)
	      {
		LABEL("  * [%d]",j);

		bool hit = tab_old[j].hit(_param, addr, ctxt);
		TEST(Tcontrol_t         , out_PREDICT_HIT          [i][j]->read(), hit);

		if (tab_old[j]._val)
		  {
		Tgeneral_data_t addr_src = tab_old[j]._address_src;

		TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_SRC  [i][j]->read(), addr_src);
		TEST(Tgeneral_data_t    , out_PREDICT_ADDRESS_DEST [i][j]->read(), ~addr_src);
		TEST(Tbranch_condition_t, out_PREDICT_CONDITION    [i][j]->read(), ((addr_src&1)?BRANCH_CONDITION_FLAG_SET:BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK));
		TEST(Tcontrol_t         , out_PREDICT_LAST_TAKE    [i][j]->read(), tab_old[j]._last_take);
// 		TEST(Tcontrol_t         , out_PREDICT_IS_ACCURATE  [i][j]->read(), );
		  }
	      }
	  }

      for (uint32_t i=0; i<_param->_nb_inst_decod  ; i++)
	if (in_DECOD_VAL [i]->read() and out_DECOD_ACK [i]->read())
	  {
	    LABEL("DECOD     [%d] : Transaction accepted",i);
	    LABEL("  * context     : %d"  ,in_DECOD_CONTEXT_ID  [i]->read());
	    LABEL("  * address_src : %.8x",in_DECOD_ADDRESS_SRC [i]->read());

	    bool hit = false;
	    
	    for (uint32_t j=0; j<_param->_associativity; j++)
	      hit |= ((tab_old[j]._val         == 1) and
		      (tab_old[j]._context     == in_DECOD_CONTEXT_ID  [i]->read()) and
		      (tab_old[j]._address_src == in_DECOD_ADDRESS_SRC [i]->read()));

	    if (not hit)
	      {
		Tptr_t k = in_DECOD_VICTIM [i]->read();

		LABEL("  * miss");
		LABEL("  * victim      : %d",k);

		tab[k]._val              = 1;
		tab[k]._context          = in_DECOD_CONTEXT_ID  [i]->read();
		tab[k]._address_src      = in_DECOD_ADDRESS_SRC [i]->read();
		tab[k]._address_dest_val = in_DECOD_CONDITION   [i]->read() == BRANCH_CONDITION_FLAG_SET;
		tab[k]._address_dest     = in_DECOD_ADDRESS_DEST[i]->read();
		tab[k]._condition        = in_DECOD_CONDITION   [i]->read();
		tab[k]._last_take        = in_DECOD_LAST_TAKE   [i]->read();
		//tab[k]._accurate         = _param->_first_accurate_if_hit;
	      }
	    else
	      {
		LABEL("  * miss");
	      }
	    
	    TEST(Tcontrol_t, out_DECOD_HIT [i]->read(), hit);
	  }

      for (uint32_t i=0; i<_param->_nb_inst_update  ; i++)
	if (in_UPDATE_VAL [i]->read() and out_UPDATE_ACK [i]->read())
	  {
	    LABEL("UPDATE    [%d] : Transaction accepted",i);
	    LABEL("  * context     : %d"  ,in_UPDATE_CONTEXT_ID  [i]->read());
	    LABEL("  * address_src : %.8x",in_UPDATE_ADDRESS_SRC [i]->read());

	    bool hit = false;
	    
	    Tptr_t k = 0;
	    for (uint32_t j=0; j<_param->_associativity; j++)
	      {
		hit |= ((tab_old[j]._val         == 1) and
			(tab_old[j]._context     == in_UPDATE_CONTEXT_ID  [i]->read()) and
			(tab_old[j]._address_src == in_UPDATE_ADDRESS_SRC [i]->read()));
		if (hit)
		  {
		    k = j;
		    break;
		  }
	      }

	    if (not hit)
	      {
		k = in_UPDATE_VICTIM [i]->read();

		LABEL("  * miss");
		LABEL("  * victim      : %d",k);

		tab[k]._val              = 1;
		tab[k]._context          = in_UPDATE_CONTEXT_ID  [i]->read();
		tab[k]._address_src      = in_UPDATE_ADDRESS_SRC [i]->read();
		tab[k]._address_dest_val = 1;
		tab[k]._address_dest     = in_UPDATE_ADDRESS_DEST[i]->read();
		tab[k]._condition        = in_UPDATE_CONDITION   [i]->read();
		tab[k]._last_take        = in_UPDATE_LAST_TAKE   [i]->read();
		//tab[k]._accurate         = (in_UPDATE_MISS_PREDICTION [i]->read())?_param->_first_accurate_if_miss:_param->_first_accurate_if_hit;
	      }
	    else
	      {
		LABEL("  * hit");
		LABEL("  * update      : %d",k);

		tab[k]._val              = 1;
		tab[k]._context          = in_UPDATE_CONTEXT_ID  [i]->read();
		tab[k]._address_src      = in_UPDATE_ADDRESS_SRC [i]->read();
		tab[k]._address_dest_val = 1;
		tab[k]._address_dest     = in_UPDATE_ADDRESS_DEST[i]->read();
		tab[k]._condition        = in_UPDATE_CONDITION   [i]->read();
		tab[k]._last_take        = in_UPDATE_LAST_TAKE   [i]->read();
		//tab[k]._accurate         = (in_UPDATE_MISS_PREDICTION [i]->read())?_param->_first_accurate_if_miss:_param->_first_accurate_if_hit;
	      }

	    TEST(Tcontrol_t, out_UPDATE_HIT [i]->read(), hit);
	  }

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_PREDICT_VAL           ;
  delete [] out_PREDICT_ACK           ;
  delete []  in_PREDICT_CONTEXT_ID    ;
  delete []  in_PREDICT_ADDRESS       ;
  delete [] out_PREDICT_HIT           ;
  delete [] out_PREDICT_ADDRESS_SRC   ;
  delete [] out_PREDICT_ADDRESS_DEST  ;
  delete [] out_PREDICT_CONDITION     ;
  delete [] out_PREDICT_LAST_TAKE     ;
  delete [] out_PREDICT_IS_ACCURATE   ;
  delete []  in_DECOD_VAL             ;
  delete [] out_DECOD_ACK             ;
  delete [] out_DECOD_HIT             ;
  delete [] out_DECOD_HIT_INDEX       ;
  delete []  in_DECOD_VICTIM          ;
  delete []  in_DECOD_CONTEXT_ID      ;
  delete []  in_DECOD_ADDRESS_SRC     ;
  delete []  in_DECOD_ADDRESS_DEST    ;
  delete []  in_DECOD_CONDITION       ;
  delete []  in_DECOD_LAST_TAKE       ;
  delete []  in_DECOD_MISS_PREDICTION ;
  delete []  in_UPDATE_VAL            ;
  delete [] out_UPDATE_ACK            ;
  delete [] out_UPDATE_HIT            ;
  delete [] out_UPDATE_HIT_INDEX      ;
  delete []  in_UPDATE_VICTIM         ;
  delete []  in_UPDATE_CONTEXT_ID     ;
  delete []  in_UPDATE_ADDRESS_SRC    ;
  delete []  in_UPDATE_ADDRESS_DEST   ;
  delete []  in_UPDATE_CONDITION      ;
  delete []  in_UPDATE_LAST_TAKE      ;
  delete []  in_UPDATE_MISS_PREDICTION;

#endif

  delete _Branch_Target_Buffer_Register;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
