#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  void Two_Level_Branch_Predictor_Glue::allocation (void)
  {
    string rename;

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"allocation","Begin");

    _component   = new Component ();

    Entity * entity = _component->set_entity (_name                 
					     ,"Two_Level_Branch_Predictor_Glue"
#ifdef POSITION
					     ,COMBINATORY
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN  
							 , SOUTH
							 , "Generalist interface"
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1,CLOCK_VHDL_NO);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1,RESET_VHDL_NO);
    }
    
    // ~~~~~[Interface : "Predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if (_param._have_bht)
      {
     in_PREDICT_BHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_prediction];
    out_PREDICT_BHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_prediction];
      }
    if (_param._have_pht)
      {
     in_PREDICT_PHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_prediction];
    out_PREDICT_PHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_prediction];
      }
    if (_param._have_bht and _param._have_pht)
     in_PREDICT_BHT_HISTORY          = new SC_IN (Tbht_history_t)       * [_param._nb_prediction];
    out_PREDICT_ACK                  = new SC_OUT(Tcontrol_t)           * [_param._nb_prediction];
     in_PREDICT_ADDRESS              = new SC_IN (Taddress_t)           * [_param._nb_prediction];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	Interface_fifo * interface = _interfaces->set_interface("predict_"+toString(i)
#ifdef POSITION
								, IN  
								, WEST
								, "Interface Predict"
#endif
								);

	if (_param._have_bht)
	  {
         in_PREDICT_BHT_ACK             [i] = interface->set_signal_in  <Tcontrol_t>     ("bht_ack"    ,1);
        out_PREDICT_BHT_ADDRESS         [i] = interface->set_signal_out <Taddress_t>     ("bht_address",_param._bht_size_address);
	  }
	if (_param._have_pht)
	  {
         in_PREDICT_PHT_ACK             [i] = interface->set_signal_in  <Tcontrol_t>     ("pht_ack"    ,1);
        out_PREDICT_PHT_ADDRESS         [i] = interface->set_signal_out <Taddress_t>     ("pht_address",_param._pht_size_address);
	  }
	if (_param._have_bht and _param._have_pht)
         in_PREDICT_BHT_HISTORY         [i] = interface->set_signal_in  <Tbht_history_t> ("bht_history",_param._bht_size_history);
        out_PREDICT_ACK                 [i] = interface->set_signal_out <Tcontrol_t>     ("ack"        ,1);
         in_PREDICT_ADDRESS             [i] = interface->set_signal_in  <Taddress_t>     ("address"    ,_param._size_address);
      }

    // ~~~~~[Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    if (_param._have_bht)
      {
     in_BRANCH_COMPLETE_BHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_BHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_branch_complete];
      }
    if (_param._have_pht)
      {
     in_BRANCH_COMPLETE_PHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_PHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_branch_complete];
      }
    if (_param._have_bht and _param._have_pht)
     in_BRANCH_COMPLETE_BHT_HISTORY          = new SC_IN (Tbht_history_t)       * [_param._nb_branch_complete];
    
    out_BRANCH_COMPLETE_ACK                  = new SC_OUT(Tcontrol_t)           * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_ADDRESS              = new SC_IN (Taddress_t)           * [_param._nb_branch_complete];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	Interface_fifo * interface = _interfaces->set_interface("branch_complete_"+toString(i)
#ifdef POSITION
								, IN  
								, EAST
								, "Interface branch complete"
#endif
								);
	if (_param._have_bht)
	  {
         in_BRANCH_COMPLETE_BHT_ACK             [i] = interface->set_signal_in  <Tcontrol_t>     ("bht_ack"    ,1);
        out_BRANCH_COMPLETE_BHT_ADDRESS         [i] = interface->set_signal_out <Taddress_t>     ("bht_address",_param._bht_size_address);
	  }
	if (_param._have_pht)
	  {
         in_BRANCH_COMPLETE_PHT_ACK             [i] = interface->set_signal_in  <Tcontrol_t>     ("pht_ack"    ,1);
        out_BRANCH_COMPLETE_PHT_ADDRESS         [i] = interface->set_signal_out <Taddress_t>     ("pht_address",_param._pht_size_address);
	  }
	if (_param._have_bht and _param._have_pht)
         in_BRANCH_COMPLETE_BHT_HISTORY         [i] = interface->set_signal_in  <Tbht_history_t> ("bht_history",_param._bht_size_history);

        out_BRANCH_COMPLETE_ACK                 [i] = interface->set_signal_out <Tcontrol_t>     ("ack"        ,1);
         in_BRANCH_COMPLETE_ADDRESS             [i] = interface->set_signal_in  <Taddress_t>     ("address"    ,_param._size_address);
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"allocation","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
#endif
