/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#include <sstream>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  std::string Parameters::msg_error(void)
  {
    std::string msg = "";

    if (_size_data < 2)
      {
        msg += "  - size_data must be > 1\n";
        msg += "    * size_data                       : " + toString(_size_data) + "\n";
      }

    if (is_positive(_nb_port) == false)
      {
        msg += "  - nb_port must be > 0\n";
        msg += "    * nb_port                         : " + toString(_nb_port) + "\n";
      }

    if (_shift_value > _size_data) 
      {
	msg += "  - shift_value must be < size_data\n";	
        msg += "    * shift_value                     : " + toString(_shift_value) + "\n";
        msg += "    * size_data                       : " + toString(_size_data)   + "\n";
      }    

    if ( (_rotate == internal_rotate) && (_carry != internal_logic))
      {
	msg += "  - Incompatible parameters : internal_rotate have never carry (must be set at \"internal_logic\"\n";
        msg += "    * rotate                          : " + toString(_rotate) + "\n";
        msg += "    * carry                           : " + toString(_carry ) + "\n";
      }    

    if (_type_completion_bool && (_size_data_completion != 1))
      {
	msg += "  - Incompatible parameters : you can't have the type of port in_SHIFTER_COMPLETION at bool. Because, This port must be more bits\n";
	msg += "    * size_data_completion            : " + toString (_size_data_completion) + "\n";
      }
      
    return msg;
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
