set size 1.0, 1.0
set terminal postscript eps enhanced color

set out "../Schema_eps/simulation_surface.eps"

unset label
unset log

set data style boxes
set boxwidth 4
set style fill solid 1.000000 border -1
   
set grid
set xlabel "Architecture"
set ylabel "Nb registers"
set yrange [0:220000]
   
set xtics rotate by -25 ('X4-1_1_4-8'  0  , \
			 'X4-1_2_2-8'  10 , \
			 'X4-1_2_2-4'  20 , \
			 'X4-2_1_2-8'  30 , \
			 'X4-2_1_2-4'  40 , \
			 'X4-1_4_1-8'  50 , \
			 'X4-1_4_1-2'  60 , \
			 'X4-2_2_1-8'  70 , \
			 'X4-2_2_1-4'  80 , \
			 'X4-2_2_1-2'  90 , \
			 'X4-4_1_1-8'  100, \
			 'X4-4_1_1-4'  110, \
			 'X4-4_1_1-2'  120  )

plot "simulation_surface_ST.dat" title "Surface ST",\
     "simulation_surface_MT.dat" title "Surface MT"
     
