/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/include/Victim.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {


#undef  FUNCTION
#define FUNCTION "Victim::Victim"
  Victim::Victim 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::victim::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    log_printf(INFO,Victim,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	switch (_param->_victim_scheme)
	  {
// 	  case VICTIM_RANDOM      : _stat = _component_victim_random      ->_stat; break;
// 	  case VICTIM_ROUND_ROBIN : _stat = _component_victim_round_robin ->_stat; break;
// 	  case VICTIM_NLU         : _stat = _component_victim_nlu         ->_stat; break;
	  case VICTIM_PSEUDO_LRU  : _stat = _component_victim_pseudo_lru  ->_stat; break;
// 	  case VICTIM_LRU         : _stat = _component_victim_lru         ->_stat; break;
// 	  case VICTIM_FIFO        : _stat = _component_victim_fifo        ->_stat; break;
	  default : break;
	  }
      }
#endif

    log_printf(FUNC,Victim,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Victim::~Victim"
  Victim::~Victim (void)
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    log_printf(INFO,Victim,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Victim,FUNCTION,"End");
  };

}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
