/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::Execution_unit_to_Write_unit"
  Execution_unit_to_Write_unit::Execution_unit_to_Write_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  {
	    if (_param->_have_port_context_id)
            sensitive << (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [i]));
            if (_param->_have_port_front_end_id)
	    sensitive << (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [i]));
            if (_param->_have_port_ooo_engine_id)
	    sensitive << (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [i]));
            if (_param->_have_port_packet_id)
	    sensitive << (*(in_EXECUTE_UNIT_OUT_PACKET_ID     [i]));

 	    sensitive << (*(in_EXECUTE_UNIT_OUT_VAL           [i]))
	            //<< (*(in_EXECUTE_UNIT_OUT_OPERATION     [i]))
	            //<< (*(in_EXECUTE_UNIT_OUT_TYPE          [i]))
		      << (*(in_EXECUTE_UNIT_OUT_WRITE_RD      [i]))
		      << (*(in_EXECUTE_UNIT_OUT_NUM_REG_RD    [i]))
		      << (*(in_EXECUTE_UNIT_OUT_DATA_RD       [i]))
		      << (*(in_EXECUTE_UNIT_OUT_WRITE_RE      [i]))
		      << (*(in_EXECUTE_UNIT_OUT_NUM_REG_RE    [i]))
		      << (*(in_EXECUTE_UNIT_OUT_DATA_RE       [i]))
		      << (*(in_EXECUTE_UNIT_OUT_EXCEPTION     [i]))
		      << (*(in_EXECUTE_UNIT_OUT_NO_SEQUENCE   [i]))
		      << (*(in_EXECUTE_UNIT_OUT_ADDRESS       [i]));
	  }
	for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	  sensitive << (*(in_WRITE_UNIT_IN_ACK [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  {
	    (*(out_EXECUTE_UNIT_OUT_ACK [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [i]));
	    if (_param->_have_port_context_id)
	    (*(out_EXECUTE_UNIT_OUT_ACK [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [i]));
	    if (_param->_have_port_front_end_id)
	    (*(out_EXECUTE_UNIT_OUT_ACK [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [i]));
	    if (_param->_have_port_ooo_engine_id)
	    (*(out_EXECUTE_UNIT_OUT_ACK [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [i]));

	    for (uint32_t j=0; j<_param->_nb_write_unit; j++)
	      (*(out_EXECUTE_UNIT_OUT_ACK [i])) (*(in_WRITE_UNIT_IN_ACK [j])); 
	  }

	for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	  {
	    (*(out_WRITE_UNIT_IN_VAL [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_VAL [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    (*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_CONTEXT_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }
	    if (_param->_have_port_front_end_id)
	      {
	    (*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_FRONT_END_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }
	    if (_param->_have_port_ooo_engine_id)
	      {
	    (*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_OOO_ENGINE_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

	    if (_param->_have_port_packet_id)
	      {
	    (*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_PACKET_ID [j]));
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_PACKET_ID [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }
	      }

// 	    (*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
// 	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
// 	      {
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_OPERATION [j]));
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
// 		if (_param->_have_port_context_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
// 		if (_param->_have_port_front_end_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
// 		if (_param->_have_port_ooo_engine_id)
// 		(*(out_WRITE_UNIT_IN_OPERATION [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
// 	      }

// 	    (*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
// 	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
// 	      {
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_TYPE [j]));
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
// 		if (_param->_have_port_context_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
// 		if (_param->_have_port_front_end_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
// 		if (_param->_have_port_ooo_engine_id)
// 		(*(out_WRITE_UNIT_IN_TYPE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
// 	      }

	    (*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_WRITE_RD [j]));
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_WRITE_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_NUM_REG_RD [j]));
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_DATA_RD [j]));
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_DATA_RD [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_WRITE_RE [j]));
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_WRITE_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_NUM_REG_RE [j]));
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NUM_REG_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_DATA_RE [j]));
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_DATA_RE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_EXCEPTION [j]));
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_EXCEPTION [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_NO_SEQUENCE [j]));
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_NO_SEQUENCE [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	    (*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_WRITE_UNIT_IN_ACK [i])); 
	    for (uint32_t j=0; j<_param->_nb_execute_unit; j++)
	      {
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_ADDRESS [j]));
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_VAL           [j]));
		if (_param->_have_port_context_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [j]));
		if (_param->_have_port_front_end_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [j]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_WRITE_UNIT_IN_ADDRESS [i])) (*(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [j]));
	      }

	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::~Execution_unit_to_Write_unit"
  Execution_unit_to_Write_unit::~Execution_unit_to_Write_unit (void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Execution_unit_to_Write_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
