/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    XML xml ("address_management");

    xml.balise_open("address_management");
    xml.singleton_begin("nb_instruction               "); xml.attribut("value",toString(_nb_instruction               )); xml.singleton_end();
    xml.singleton_begin("size_address                 "); xml.attribut("value",toString(_size_address                 )); xml.singleton_end();
    xml.singleton_begin("size_branch_update_prediction"); xml.attribut("value",toString(_size_branch_update_prediction)); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Address_management,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Address_management::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::address_management::Parameters & x)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Address_management,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
