#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

#undef  FUNCTION
#define FUNCTION "Ifetch_queue::genMoore"
  void Ifetch_queue::genMoore (void)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    // ==========================================================
    // =====[ ADDRESS ]==========================================
    // ==========================================================
    internal_ADDRESS_ACK = (_queue[reg_PTR_WRITE]->_state == IFETCH_QUEUE_STATE_EMPTY);

    PORT_WRITE(out_ADDRESS_ACK            , internal_ADDRESS_ACK);
    if (_param->_have_port_queue_ptr)
    PORT_WRITE(out_ADDRESS_IFETCH_QUEUE_ID, reg_PTR_WRITE);

    // ==========================================================
    // =====[ DECOD ]============================================
    // ==========================================================
    bool ack = (_queue[reg_PTR_READ]->_state == IFETCH_QUEUE_STATE_HAVE_RSP);

    for (uint32_t i=0; i<_param->_nb_instruction; i++)
      {
	internal_DECOD_VAL [i] = ack and _queue[reg_PTR_READ]->_instruction_enable [i];
	PORT_WRITE(out_DECOD_VAL         [i], internal_DECOD_VAL [i]);
	PORT_WRITE(out_DECOD_INSTRUCTION [i],         _queue[reg_PTR_READ]->_instruction        [i]);
      }

    PORT_WRITE(out_DECOD_ADDRESS                    , _queue[reg_PTR_READ]->_address                    );
    if (_param->_have_port_instruction_ptr)
    PORT_WRITE(out_DECOD_INST_IFETCH_PTR            , _queue[reg_PTR_READ]->_inst_ifetch_ptr            );
    PORT_WRITE(out_DECOD_BRANCH_STATE               , _queue[reg_PTR_READ]->_branch_state               );
    if (_param->_have_port_branch_update_prediction_id)
    PORT_WRITE(out_DECOD_BRANCH_UPDATE_PREDICTION_ID, _queue[reg_PTR_READ]->_branch_update_prediction_id);
    PORT_WRITE(out_DECOD_EXCEPTION                  , _queue[reg_PTR_READ]->_exception                  );

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
