#ifndef ENVIRONNEMENT_CACHE_CACHE_MULTILEVEL_H
#define ENVIRONNEMENT_CACHE_CACHE_MULTILEVEL_H

#include "Cache_MultiLevel_Parameters.h"
#include "Cache_MultiLevel_Access.h"
#include "Cache_OneLevel.h"

namespace environnement {
namespace cache {
namespace cache_multilevel {

  class Cache_MultiLevel
  {
  protected : std::string  name;
  public    : Parameters * param;
  protected : cache_onelevel::Cache_OneLevel ** hierarchy_cache;
    
  public    :  Cache_MultiLevel (std::string name, Parameters * param);
  public    : ~Cache_MultiLevel (void);

  public    : void             reset         (void);
  public    : void             transition    (void);
  public    : Access           access        (uint32_t num_port, uint32_t address, uint32_t trdid, type_req_cache_t type, direction_req_cache_t dir);
  public    : uint32_t         latence       (uint32_t num_port, uint32_t address, uint32_t trdid, type_req_cache_t type, direction_req_cache_t dir);
  public    : uint32_t         update_access (Access cur_access);

  public    : std::string      information   (uint32_t depth);
  public    : friend std::ostream& operator<< (std::ostream& output, Cache_MultiLevel & x);
  };

};
};
};
#endif
