#include "../include/Cache_MultiLevel.h"
#include <sstream>

namespace environnement {
namespace cache {
namespace cache_multilevel {

  Cache_MultiLevel::Cache_MultiLevel (std::string name,
				      Parameters * param)
  {
    this->name  = name;
    this->param = param;

    hierarchy_cache = new cache_onelevel::Cache_OneLevel * [param->nb_level];
    
    for (uint32_t i=0; i<param->nb_level; i++)
      {
	std::stringstream str;

	str << name << "_level_" << i;

	hierarchy_cache[i] = new cache_onelevel::Cache_OneLevel (str.str(), param->param_cache[i]);
      }
  }

  Cache_MultiLevel::~Cache_MultiLevel (void)
  {
    for (uint32_t i=0; i<param->nb_level; i++)
      delete hierarchy_cache [i];
    delete [] hierarchy_cache;
  }
};
};
};
