/*
 * $Id$
 *
 * [ Description ]
 * 
 * instruction MAC_UNIT (l.mac, l.maci, l.macrc, l.msb) throw a context event. Also is sequential.
 * If your program need intensive mac_unit, you can change the implementation of this unit :
 *  1) "decod"            : inst->_event_type = EVENT_TYPE_NONE;
 *  2) "rename"           : add component as load_store_unit pointer management
 *  3) "functionnal_unit" : test type instruction, if type=MAC_UNIT, insert in queue, the localisation is the ptr give by rename stage. Retire in this queue in sequence (as the store queue).
 *
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/Instruction/include/Instruction.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {

#define EXTENDS(x,nb_bits) extend<Tgeneral_data_t>(32, x,true ,nb_bits)
#define EXTENDZ(x,nb_bits) extend<Tgeneral_data_t>(32, x,false,nb_bits)

  void instruction_decod               (decod_instruction_t * inst, decod_param_t * param)
  {
//     instruction_decod_type_0 (inst,param);

    uint32_t opcod = range<uint32_t>(inst->_instruction,31,26);
    (* param->_function_decod[ 0][opcod]) (inst,param);
  }

//   void instruction_decod_type_0        (decod_instruction_t * inst, decod_param_t * param)
//   {
//     uint32_t opcod = range<uint32_t>(inst->_instruction,31,26);
//     (* param->_function_decod[ 0][opcod]) (inst,param);
//   }

  void instruction_decod_type_1        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);
    (* param->_function_decod[ 1][opcod]) (inst,param);
  }

  void instruction_decod_type_2        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);
    (* param->_function_decod[ 2][opcod]) (inst,param);
  }

  void instruction_decod_type_3        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = ((range<uint32_t>(inst->_instruction, 9, 8)<<4) |
		      (range<uint32_t>(inst->_instruction, 3, 0)));
    (* param->_function_decod[ 3][opcod]) (inst,param);
  }

  void instruction_decod_type_4        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction,25,21);
    (* param->_function_decod[ 4][opcod]) (inst,param);
  }

  void instruction_decod_type_5        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction,25,21);
    (* param->_function_decod[ 5][opcod]) (inst,param);
  }

  void instruction_decod_type_6        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);
    (* param->_function_decod[ 6][opcod]) (inst,param);
  }

  void instruction_decod_type_7        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 3, 0);
    (* param->_function_decod[ 7][opcod]) (inst,param);
  }

  void instruction_decod_type_8        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction,16,16);
    (* param->_function_decod[ 8][opcod]) (inst,param);
  }

  void instruction_decod_type_9        (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction,25,23);
    (* param->_function_decod[ 9][opcod]) (inst,param);
  }

  void instruction_decod_type_10       (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction,25,24);
    (* param->_function_decod[10][opcod]) (inst,param);
  }

  void instruction_decod_type_11       (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);
    (* param->_function_decod[11][opcod]) (inst,param);
  }

  void instruction_decod_type_12       (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);
    (* param->_function_decod[12][opcod]) (inst,param);
  }

  void instruction_decod_type_13       (decod_instruction_t * inst, decod_param_t * param)
  {
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);
    (* param->_function_decod[13][opcod]) (inst,param);
  }

  void instruction_illegal             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_illegal","instruction_illegal");
	
    inst->_exception_use = EXCEPTION_USE_ILLEGAL_INSTRUCTION;

    if (inst->_is_delay_slot)
      inst->_address_next       = inst->_address_previous;
    else
      inst->_address_next       = inst->_address;

    inst->_event_type         = EVENT_TYPE_EXCEPTION;
  }
  
  // ORBIS
  void instruction_l_add               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_add","  * instruction   : l.add");
    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addc              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addc","  * instruction   : l.addc");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_CY_OV;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addi              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addi","  * instruction   : l.addi");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addic             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addic","  * instruction   : l.addic");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_CY_OV;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_and               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_and","  * instruction   : l.and");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_AND;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_andi              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_andi","  * instruction   : l.andi");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_AND;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_bf	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_bf","  * instruction   : l.bf");

    Tgeneral_data_t address_next = inst->_address+(EXTENDS(inst->_instruction,26)<<2);

    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_L_TEST_F;
    inst->_has_immediat       = 1;
    inst->_immediat           = address_next;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_FLAG_SET;
//  inst->_branch_stack_write = 0;

    inst->_branch_direction   = range<Tgeneral_data_t   >(inst->_instruction,25,25);
    inst->_address_next       = address_next;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_bnf               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_bnf","  * instruction   : l.bnf");

    Tgeneral_data_t address_next = inst->_address+(EXTENDS(inst->_instruction,26)<<2);

    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_L_TEST_NF;
    inst->_has_immediat       = 1;
    inst->_immediat           = address_next;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_FLAG_UNSET;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = range<Tgeneral_data_t   >(inst->_instruction,25,25);
    inst->_address_next       = address_next;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_cmov              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_cmov","  * instruction   : l.cmov");

    inst->_type               = TYPE_MOVE;
    inst->_operation          = OPERATION_MOVE_L_CMOV;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_csync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_csync","  * instruction   : l.csync");

    if (range<Tinstruction_t>(inst->_instruction,23) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_CSYNC;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_CSYNC;
      }
  }

//   void instruction_l_cust1             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust2             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust3             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust4             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust5             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust6             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust7             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust8             (decod_instruction_t * inst, decod_param_t * param)

  void instruction_l_div               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_div","  * instruction   : l.div");

    inst->_type               = TYPE_MUL_DIV;
    inst->_operation          = OPERATION_MUL_DIV_L_DIV;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_divu              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_divu","  * instruction   : l.divu");

    inst->_type               = TYPE_MUL_DIV;
    inst->_operation          = OPERATION_MUL_DIV_L_DIVU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extbs             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extbs","  * instruction   : l.extbs");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 8;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extbz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extbz","  * instruction   : l.extbz");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 8;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_exths             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_exths","  * instruction   : l.exths");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 16;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_exthz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_exthz","  * instruction   : l.exthz");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 16;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extws             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extws","  * instruction   : l.extws");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 32;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extwz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extwz","  * instruction   : l.extwz");

    inst->_type               = TYPE_EXTEND;
    inst->_operation          = OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 32;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_ff1               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ff1","  * instruction   : l.ff1");

    inst->_type               = TYPE_FIND;
    inst->_operation          = OPERATION_FIND_L_FF1;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_fl1               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_fl1","  * instruction   : l.fl1");

    inst->_type               = TYPE_FIND;
    inst->_operation          = OPERATION_FIND_L_FL1;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_j                 (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_j","  * instruction   : l.j");

    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_NONE;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = 1;
    inst->_address_next       = inst->_address+(EXTENDS(inst->_instruction,26)<<2);
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_jal               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jal","  * instruction   : l.jal");

    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 1;
    inst->_immediat           = inst->_address_next+4;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = 9; // Link register
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_NONE_WITH_WRITE_STACK; // Always jump
//  inst->_branch_stack_write = 1;
    inst->_branch_direction   = 1;
    inst->_address_next       = inst->_address+(EXTENDS(inst->_instruction,26)<<2);
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_jalr              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jalr","  * instruction   : l.jalr");

    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);

    if (inst->_num_reg_rb == 9)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 1;
//  inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = 9; // Link register
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = (inst->_num_reg_rb == 9)?BRANCH_CONDITION_READ_STACK:BRANCH_CONDITION_READ_REGISTER;
    inst->_branch_condition   = BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK;
//  inst->_branch_stack_write = 1;
    inst->_branch_direction   = 1;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
      }
  }

  void instruction_l_jr                (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jr","  * instruction   : l.jr");

    inst->_type               = TYPE_BRANCH;
    inst->_operation          = OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_branch_condition   = (inst->_num_reg_rb == 9)?BRANCH_CONDITION_READ_STACK:BRANCH_CONDITION_READ_REGISTER_WITHOUT_WRITE_STACK;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = 1;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lbs               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lbs","  * instruction   : l.lbs");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_8_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lbz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lbz","  * instruction   : l.lbz");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_8_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_ld	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ld","  * instruction   : l.ld");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_64_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lhs               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lhs","  * instruction   : l.lhs");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_16_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lhz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lhz","  * instruction   : l.lhz");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_16_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lws               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lws","  * instruction   : l.lws");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_32_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lwz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lwz","  * instruction   : l.lwz");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_LOAD_32_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_mac               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mac","  * instruction   : l.mac");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MAC;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_maci              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_maci","  * instruction   : l.maci");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MAC;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_macrc             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_macrc","  * instruction   : l.macrc");

    if (range<uint32_t>(inst->_instruction,15, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MACRC;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
      }
  }

  void instruction_l_mfspr             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mfspr","  * instruction   : l.mfspr");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MFSPR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_movhi             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_movhi","  * instruction   : l.movhi");

    inst->_type               = TYPE_MOVE;
    inst->_operation          = OPERATION_MOVE_L_MOVHI;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_msb               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_msb","  * instruction   : l.msb");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MSB;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_msync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_msync","  * instruction   : l.msync");

    if (range<uint32_t>(inst->_instruction,22, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MSYNC;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_MSYNC;
      }
  }

  void instruction_l_mtspr             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mtspr","  * instruction   : l.mtspr");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_MTSPR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }
    
  void instruction_l_mul               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mul","  * instruction   : l.mul");

    inst->_type               = TYPE_MUL_DIV;
    inst->_operation          = OPERATION_MUL_DIV_L_MUL;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_muli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_muli","  * instruction   : l.muli");

    inst->_type               = TYPE_MUL_DIV;
    inst->_operation          = OPERATION_MUL_DIV_L_MUL;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_mulu              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mulu","  * instruction   : l.mulu");

    inst->_type               = TYPE_MUL_DIV;
    inst->_operation          = OPERATION_MUL_DIV_L_MULU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_nop               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_nop","  * instruction   : l.nop");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_NOP;
//  inst->_has_immediat       = 1;
//  inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_or                (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_or","  * instruction   : l.or");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_OR;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_ori               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ori","  * instruction   : l.ori");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_OR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_psync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_psync","  * instruction   : l.psync");

    if (range<uint32_t>(inst->_instruction,22, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_PSYNC;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_PSYNC;
      }
  }

  void instruction_l_rfe               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_rfe","  * instruction   : l.rfe");

    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_RFE;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_NONE; // can't anticip this instruction : must read EPCR in rename stage
  }

  void instruction_l_ror               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ror","  * instruction   : l.ror");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_ROR;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_rori              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_rori","  * instruction   : l.rori");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_ROR;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sb	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sb","  * instruction   : l.sb");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_STORE_8;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sd	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sb","  * instruction   : l.sb");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_STORE_64;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfeq              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfeq","  * instruction   : l.sfeq");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFEQ;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfeqi             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfeqi","  * instruction   : l.sfeqi");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFEQ;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfges             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfges","  * instruction   : l.sfges");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGES;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgesi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgesi","  * instruction   : l.sfgesi");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGES;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgeu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgeu","  * instruction   : l.sfgeu");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGEU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgeui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgeui","  * instruction   : l.sfgeui");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGEU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgts             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgts","  * instruction   : l.sfgts");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGTS;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtsi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtsi","  * instruction   : l.sfgtsi");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGTS;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtu","  * instruction   : l.sfgtu");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGTU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtui","  * instruction   : l.sfgtui");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFGTU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfles             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfles","  * instruction   : l.sfles");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLES;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sflesi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sflesi","  * instruction   : l.sflesi");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLES;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfleu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfleu","  * instruction   : l.sfleu");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLEU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfleui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfleui","  * instruction   : l.sfleui");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLEU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sflts             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sflts","  * instruction   : l.sflts");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLTS;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltsi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltsi","  * instruction   : l.sfltsi");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLTS;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltu","  * instruction   : l.sfltu");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLTU;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltui","  * instruction   : l.sfltui");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFLTU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfne              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfne","  * instruction   : l.sfne");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFNE;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfnei             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfnei","  * instruction   : l.sfnei");

    inst->_type               = TYPE_TEST;
    inst->_operation          = OPERATION_TEST_L_SFNE;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sh	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sh","  * instruction   : l.sh");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_STORE_16;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sll               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sll","  * instruction   : l.sll");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SLL;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_slli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_slli","  * instruction   : l.slli");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SLL;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sra               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sra","  * instruction   : l.sra");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SRA;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srai              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srai","  * instruction   : l.srai");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SRA;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srl               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srl","  * instruction   : l.srl");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SRL;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srli","  * instruction   : l.srli");

    inst->_type               = TYPE_SHIFT;
    inst->_operation          = OPERATION_SHIFT_L_SRL;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
    
  void instruction_l_sub               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sub","  * instruction   : l.sub");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_SUB;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sw	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sw","  * instruction   : l.sw");

    inst->_type               = TYPE_MEMORY;
    inst->_operation          = OPERATION_MEMORY_STORE_32;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sys               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sys","  * instruction   : l.sys");

    if (range<uint32_t>(inst->_instruction,22,16) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_SYS;
//  inst->_has_immediat       = 1;
//  inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_SYSCALL;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;

//     if (inst->_is_delay_slot)
//       inst->_address_next       = inst->_address_previous;
//     else
//       inst->_address_next       = inst->_address;


//  inst->_address_next       = ; // don't change
    inst->_event_type         = EVENT_TYPE_EXCEPTION;
      }
  }

  void instruction_l_trap              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_trap","  * instruction   : l.trap");

    if (range<uint32_t>(inst->_instruction,22,16) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
    inst->_type               = TYPE_SPECIAL;
    inst->_operation          = OPERATION_SPECIAL_L_TRAP;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 0;
//  inst->_num_reg_ra         = ;
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0; // read all SR
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 0;
//  inst->_num_reg_rd         = ;
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_TRAP;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
      }
  }

  void instruction_l_xor               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_xor","  * instruction   : l.xor");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_XOR;
    inst->_has_immediat       = 0;
//  inst->_immediat           = ;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_xori              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_xori","  * instruction   : l.xori");

    inst->_type               = TYPE_ALU;
    inst->_operation          = OPERATION_ALU_L_XOR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
//  inst->_num_reg_rb         = ;
    inst->_read_rc            = 0;
//  inst->_num_reg_rc         = ;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
//  inst->_num_reg_re         = ;
    inst->_exception_use      = EXCEPTION_USE_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

//   // ORFPX
//   void instruction_lf_add_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_add_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_cust1_d          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_cust1_s          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_div_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_div_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_ftoi_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_ftoi_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_itof_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_itof_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_madd_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_madd_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_mul_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_mul_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_rem_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_rem_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfeq_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfeq_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfge_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfge_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfgt_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfgt_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfle_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfle_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sflt_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sflt_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfne_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfne_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sub_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sub_s            (decod_instruction_t * inst, decod_param_t * param)

//   // ORVDX
//   void instruction_lv_add_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_add_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_adds_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_adds_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addu_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addu_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addus_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addus_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_and              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_avg_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_avg_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust1            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust2            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust3            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust4            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_madds_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_max_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_max_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_merge_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_merge_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_min_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_min_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_msubs_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_muls_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_nand             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_nor              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_or               (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_pack_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_pack_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packs_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packs_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packus_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packus_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_perm_n           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_rl_b             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_rl_h             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sra_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sra_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sub_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sub_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subs_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subs_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subu_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subu_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subus_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subus_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_unpack_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_unpack_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_xor              (decod_instruction_t * inst, decod_param_t * param)

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
