/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Ifetch_unit_Glue * _Ifetch_unit_Glue = new Ifetch_unit_Glue (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC_SC_SIGNAL(out_ICACHE_REQ_VAL        ,"out_ICACHE_REQ_VAL        ",Tcontrol_t);
  ALLOC_SC_SIGNAL( in_ICACHE_REQ_ADDRESS_VAL," in_ICACHE_REQ_ADDRESS_VAL",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_ICACHE_REQ_QUEUE_VAL  ,"out_ICACHE_REQ_QUEUE_VAL  ",Tcontrol_t);
  ALLOC_SC_SIGNAL( in_ICACHE_REQ_ACK        ," in_ICACHE_REQ_ACK        ",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_ICACHE_REQ_ADDRESS_ACK,"out_ICACHE_REQ_ADDRESS_ACK",Tcontrol_t);
  ALLOC_SC_SIGNAL( in_ICACHE_REQ_QUEUE_ACK  ," in_ICACHE_REQ_QUEUE_ACK  ",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_ICACHE_REQ_TYPE       ,"out_ICACHE_REQ_TYPE       ",Ticache_type_t);
  ALLOC_SC_SIGNAL( in_EVENT_VAL             ," in_EVENT_VAL             ",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_EVENT_ADDRESS_VAL     ,"out_EVENT_ADDRESS_VAL     ",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_EVENT_QUEUE_VAL       ,"out_EVENT_QUEUE_VAL       ",Tcontrol_t);
  ALLOC_SC_SIGNAL(out_EVENT_ACK             ,"out_EVENT_ACK             ",Tcontrol_t);
  ALLOC_SC_SIGNAL( in_EVENT_ADDRESS_ACK     ," in_EVENT_ADDRESS_ACK     ",Tcontrol_t);
  ALLOC_SC_SIGNAL( in_EVENT_QUEUE_ACK       ," in_EVENT_QUEUE_ACK       ",Tcontrol_t);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Ifetch_unit_Glue.\n"),name.c_str());

  (*(_Ifetch_unit_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Ifetch_unit_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_VAL        );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_ADDRESS_VAL);
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_QUEUE_VAL  );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_ACK        );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_ADDRESS_ACK);
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_QUEUE_ACK  );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_TYPE       );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_VAL             );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_ADDRESS_VAL     );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_QUEUE_VAL       );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_ACK             );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_ADDRESS_ACK     );
  INSTANCE_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_QUEUE_ACK       );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete out_ICACHE_REQ_VAL        ;
  delete  in_ICACHE_REQ_ADDRESS_VAL;
  delete out_ICACHE_REQ_QUEUE_VAL  ;
  delete  in_ICACHE_REQ_ACK        ;
  delete out_ICACHE_REQ_ADDRESS_ACK;
  delete  in_ICACHE_REQ_QUEUE_ACK  ;
  delete out_ICACHE_REQ_TYPE       ;
  delete  in_EVENT_VAL             ;
  delete out_EVENT_ADDRESS_VAL     ;
  delete out_EVENT_QUEUE_VAL       ;
  delete out_EVENT_ACK             ;
  delete  in_EVENT_ADDRESS_ACK     ;
  delete  in_EVENT_QUEUE_ACK       ;
#endif

  delete _Ifetch_unit_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
