/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::Free_List_unit"
  Free_List_unit::Free_List_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    log_printf(INFO,Free_List_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Free_List_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Free_List_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Free_List_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Free_List_unit,FUNCTION,"Method - genMealy_pop");

	SC_METHOD (genMealy_pop);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_pop; i++)
	  sensitive << (*(in_POP_GPR_VAL[i]))
		    << (*(in_POP_SPR_VAL[i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	
	for (uint32_t i=0; i<_param->_nb_pop; i++)
	  {
	    (*(out_POP_GPR_NUM_REG [i])) (*(in_POP_GPR_VAL[i]));
	    (*(out_POP_SPR_NUM_REG [i])) (*(in_POP_SPR_VAL[i]));
	    (*(out_POP_ACK         [i])) (*(in_POP_GPR_VAL[i]));
	    (*(out_POP_ACK         [i])) (*(in_POP_SPR_VAL[i]));
	  }
# endif

	log_printf(INFO,Free_List_unit,FUNCTION,"Method - genMealy_push_gpr");

	SC_METHOD (genMealy_push_gpr);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  sensitive << (*(in_PUSH_GPR_VAL    [i]))
		    << (*(in_PUSH_GPR_NUM_REG[i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  {
	    (*(out_PUSH_GPR_ACK         [i])) (*(in_PUSH_GPR_VAL    [i]));
	    (*(out_PUSH_GPR_ACK         [i])) (*(in_PUSH_GPR_NUM_REG[i]));
	  }
# endif

	log_printf(INFO,Free_List_unit,FUNCTION,"Method - genMealy_push_spr");

	SC_METHOD (genMealy_push_spr);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  sensitive << (*(in_PUSH_SPR_VAL    [i]))
		    << (*(in_PUSH_SPR_NUM_REG[i]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  {
	    (*(out_PUSH_SPR_ACK         [i])) (*(in_PUSH_SPR_VAL    [i]));
	    (*(out_PUSH_SPR_ACK         [i])) (*(in_PUSH_SPR_NUM_REG[i]));
	  }
# endif

#endif
      }
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Free_List_unit::~Free_List_unit"
  Free_List_unit::~Free_List_unit (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Free_List_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Free_List_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
