#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::genMealy_push_gpr"
  void Free_List_unit::genMealy_push_gpr (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    bool bank_use [_param->_nb_bank];
    for (uint32_t i=0; i<_param->_nb_bank; i++)
      bank_use [i] = false;

    for (uint32_t i=0; i<_param->_nb_push; i++)
      {
	bool gpr_ack = not PORT_READ(in_PUSH_GPR_VAL[i]);

	if (not gpr_ack)
	  {
	    // num_bank : MSB
	    uint32_t bank = PORT_READ(in_PUSH_GPR_NUM_REG[i]) >> _param->_bank_gpr_size_slot;
	    
	    if (not bank_use [bank])
	      {
		// find
		gpr_ack = true;
		internal_PUSH_GPR_BANK [i] = bank;
		bank_use [bank] = true;
	      }
	  }

	internal_PUSH_GPR_ACK [i] = gpr_ack;
	PORT_WRITE(out_PUSH_GPR_ACK [i], internal_PUSH_GPR_ACK [i]);
      }
    
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
