/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                       (uint32_t)\n"));
  err (_(" * nb_context          [nb_front_end]	(uint32_t)\n"));
  err (_(" * nb_general_register   		(uint32_t)\n"));
  err (_(" * nb_special_register                (uint32_t)\n"));
  err (_(" * nb_inst_insert        		(uint32_t)\n"));
  err (_(" * nb_inst_retire                     (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name      =      argv[x++];

  uint32_t   _nb_front_end        = atoi(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);
  
  uint32_t * _nb_context          = new uint32_t [_nb_front_end];

  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_context [i] = atoi(argv[x++]);

  uint32_t   _nb_general_register = atoi(argv[x++]);
  uint32_t   _nb_special_register = atoi(argv[x++]);
  uint32_t   _nb_inst_insert      = atoi(argv[x++]);
  uint32_t   _nb_inst_retire      = atoi(argv[x++]);
  
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters
	(_nb_front_end        ,
	 _nb_context          ,
	 _nb_general_register ,
	 _nb_special_register ,
	 _nb_inst_insert      ,
	 _nb_inst_retire      );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

