/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * victim_scheme (Tvictim_t)\n"));
  err (_(" * nb_entity     (uint32_t )\n"));
  err (_(" * nb_entry      (uint32_t )\n"));
  err (_(" * nb_access     (uint32_t )\n"));
  err (_(" * table_global  (bool     )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  Tvictim_t _victim_scheme = fromString<Tvictim_t>(argv[x++]);
  uint32_t  _nb_entity     = fromString<uint32_t >(argv[x++]);
  uint32_t  _nb_entry      = fromString<uint32_t >(argv[x++]);
  uint32_t  _nb_access     = fromString<uint32_t >(argv[x++]);
  bool      _table_global  = fromString<bool     >(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::generic::victim::Parameters * param = new morpheo::behavioural::generic::victim::Parameters
	(_victim_scheme,
	 _nb_entity    ,
	 _nb_entry     ,
	 _nb_access    ,
	 _table_global );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
