#!/bin/sh

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage     : ${0} file";
    echo "Arguments : ";
    echo ' * file : you can see the lock at "${MORPHEO_HOME}/lock/$(basename file).lock"';
    echo "Notes     :";
    echo " * Morpheo's environnement must be positionned.";

    exit;
}

#-----[ lock ]----------------------------------------------
function lock ()
{
    lockfile -1 ${1};
}

#-----[ main ]----------------------------------------------
function main ()
{
    LOCK_DIRECTORY="${MORPHEO_HOME}/lock";

    if test ${#} -ne 1 -o -z ${MORPHEO_HOME} -o ! -d ${LOCK_DIRECTORY}; then
	usage ${*};
    fi;

    lock "${LOCK_DIRECTORY}/$(basename ${1}).lock"
}

#-----[ Corps ]---------------------------------------------
main ${*}
