#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::transition"
  void Write_queue::transition (void)
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	// Flush queue
	// FIXME "queue reset"
	// > 1) flush one slot by cycle
	// > 2) flush all slot in one cycle

	while (_queue->empty() == false)
	  _queue->pop_front();
      }
    else
      {
	// Test access at gpr and spr
	if (internal_GPR_WRITE_VAL and PORT_READ(in_GPR_WRITE_ACK[0]))
	  _queue->front()->_write_rd = 0;
	if (internal_SPR_WRITE_VAL and PORT_READ(in_SPR_WRITE_ACK[0]))
	  _queue->front()->_write_re = 0;

	// Test if push
	if (PORT_READ(in_WRITE_QUEUE_IN_VAL) and internal_WRITE_QUEUE_IN_ACK)
	  {
	    write_queue_entry_t * entry = new write_queue_entry_t
	      ((_param->_have_port_context_id   )?PORT_READ(in_WRITE_QUEUE_IN_CONTEXT_ID   ):0,
	       (_param->_have_port_front_end_id )?PORT_READ(in_WRITE_QUEUE_IN_FRONT_END_ID ):0,
	       (_param->_have_port_ooo_engine_id)?PORT_READ(in_WRITE_QUEUE_IN_OOO_ENGINE_ID):0,
	       (_param->_have_port_packet_id    )?PORT_READ(in_WRITE_QUEUE_IN_PACKET_ID    ):0,
	     //PORT_READ(in_WRITE_QUEUE_IN_OPERATION    ),
	       PORT_READ(in_WRITE_QUEUE_IN_TYPE         ),
	       PORT_READ(in_WRITE_QUEUE_IN_WRITE_RD     ),
	       PORT_READ(in_WRITE_QUEUE_IN_NUM_REG_RD   ),
	       PORT_READ(in_WRITE_QUEUE_IN_DATA_RD      ),
	       PORT_READ(in_WRITE_QUEUE_IN_WRITE_RE     ),
	       PORT_READ(in_WRITE_QUEUE_IN_NUM_REG_RE   ),
	       PORT_READ(in_WRITE_QUEUE_IN_DATA_RE      ),
	       PORT_READ(in_WRITE_QUEUE_IN_EXCEPTION    ),
	       PORT_READ(in_WRITE_QUEUE_IN_NO_SEQUENCE  ),
	       PORT_READ(in_WRITE_QUEUE_IN_ADDRESS      ));
	    
	    _queue->push_back(entry);
	  }

	// Test if pop :
	//  * transaction on write_queue_out interface
	//  * have a speculative load and all register is write in registerfile
	if ( (internal_WRITE_QUEUE_OUT_VAL and PORT_READ(in_WRITE_QUEUE_OUT_ACK)) or
	     ((_queue->empty() == false)                                         and
	      (_queue->front()->_type      == TYPE_MEMORY)                       and
	      (_queue->front()->_exception == EXCEPTION_MEMORY_LOAD_SPECULATIVE) and
	      (_queue->front()->_write_rd  == 0)                                 and
	      (_queue->front()->_write_re  == 0)))
	  {
	    delete _queue->front();
	    _queue->pop_front();
	  }
      }

#ifdef STATISTICS
    *(_stat_use_queue) += _queue->size();
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
