/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {


#ifdef SYSTEMC
  RegisterFile::RegisterFile (sc_module_name name,
#else
  RegisterFile::RegisterFile (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             * param_statistics,
#endif
			      morpheo::behavioural::generic::registerfile::Parameters * param ):
			      _name              (name)
			      ,_param            (param)
  {
    log_printf(FUNC,RegisterFile,"RegisterFile","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile,"RegisterFile","Allocation");

    allocation (
# ifdef STATISTICS
		param_statistics
# endif
		);
#endif

#ifdef STATISTICS
    if (_param->_instance == instance_RegisterFile_Monolithic)
      _stat = component_RegisterFile_Monolithic  ->_stat;
    else
      _stat = component_RegisterFile_Multi_Banked->_stat;
#endif

    log_printf(FUNC,RegisterFile,"RegisterFile","End");
  };
  
  RegisterFile::~RegisterFile (void)
  {
    log_printf(FUNC,RegisterFile,"~RegisterFile","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile,"~RegisterFile","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,RegisterFile,"~RegisterFile","End");
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
