#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include <time.h>
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_header"
  std::string Vhdl::get_header(uint32_t depth,
			  std::string   filename)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string        tab = std::string(depth,'\t');
    std::ostringstream text;

    time_t current_time;
    time (&current_time);

    text << tab << "-------------------------------------------------------------------------------" << std::endl
	 << tab << "-- file      : " << filename                                                     << std::endl
	 << tab << "-- date      : " << ctime (&current_time )
	 << tab << "-- comment   : it's a autogenerated file : don't modify"                         << std::endl
	 << tab << "-------------------------------------------------------------------------------" << std::endl;
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
