/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {


#undef  FUNCTION
#define FUNCTION "Direction::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Direction,FUNCTION,"Begin");

    XML xml ("direction");

    xml.balise_open("direction");
    xml.singleton_begin("predictor_scheme                  "); xml.attribut("value",toString(_predictor_scheme)); xml.singleton_end();
    xml.singleton_begin("nb_inst_predict                   "); xml.attribut("value",toString(_nb_inst_predict )); xml.singleton_end();
    xml.singleton_begin("nb_inst_update                    "); xml.attribut("value",toString(_nb_inst_update  )); xml.singleton_end();
    xml.singleton_begin("size_address                      "); xml.attribut("value",toString(_size_address    )); xml.singleton_end();

    xml.comment("predictor_scheme : ");
    xml.comment(" * predictor_never_take  : don't use \"predictor_{0,1,2}\" parameters.");
    xml.comment(" * predictor_always_take : don't use \"predictor_{0,1,2}\" parameters.");
    xml.comment(" * predictor_static      : don't use \"predictor_{0,1,2}\" parameters.");
    xml.comment(" * predictor_last_take   : don't use \"predictor_{0,1,2}\" parameters.");
    xml.comment(" * predictor_counter     :       use \"predictor_0\"       parameters.");
    xml.comment(" * predictor_local       :       use \"predictor_0\"       parameters.");
    xml.comment(" * predictor_global      :       use \"predictor_0\"       parameters.");
    xml.comment(" * predictor_meta        :       use \"predictor_{0,1,2}\" parameters.");
    xml.comment(" * predictor_custom      :       use \"predictor_{0,1,2}\" parameters.");
    for (uint32_t i=0; i<3; i++)
      {
	xml.singleton_begin("predictor_"+toString(i)+"_have_bht              "); xml.attribut("value",toString(_have_bht               [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_bht_size_shifter      "); xml.attribut("value",toString(_bht_size_shifter       [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_bht_nb_shifter        "); xml.attribut("value",toString(_bht_nb_shifter         [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_have_pht              "); xml.attribut("value",toString(_have_pht               [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_pht_size_counter      "); xml.attribut("value",toString(_pht_size_counter       [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_pht_nb_counter        "); xml.attribut("value",toString(_pht_nb_counter         [i])); xml.singleton_end();
	xml.singleton_begin("predictor_"+toString(i)+"_pht_size_address_share"); xml.attribut("value",toString(_pht_size_address_share [i])); xml.singleton_end();
      }
    xml.balise_close();

    log_printf(FUNC,Direction,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Direction::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::Parameters & x)
  {
    log_printf(FUNC,Direction,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Direction,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
