/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    XML xml ("load_store_pointer_unit");

    xml.balise_open("load_store_pointer_unit");
    xml.singleton_begin("nb_front_end                    "); xml.attribut("value",toString(_nb_front_end                    )); xml.singleton_end();
    xml.singleton_begin("nb_inst_insert                  "); xml.attribut("value",toString(_nb_inst_insert                  )); xml.singleton_end();
    xml.singleton_begin("nb_inst_retire                  "); xml.attribut("value",toString(_nb_inst_retire                  )); xml.singleton_end();
    xml.singleton_begin("nb_load_store_queue             "); xml.attribut("value",toString(_nb_load_store_queue             )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_front_end; i++)
      {
	xml. balise_open_begin("component");
	xml.  attribut("type","front_end");
	xml.  attribut("id"  ,toString(i));
	xml. balise_open_end();
	xml.  singleton_begin("nb_context                      "); xml.attribut("value",toString(_nb_context [i]     )); xml.singleton_end();
	xml. balise_close();
      }
    for (uint32_t i=0;i<_nb_load_store_queue; i++)
      {
	xml. balise_open_begin("component");
	xml.  attribut("type","load_store_queue");
	xml.  attribut("id"  ,toString(i));
	xml. balise_open_end();
	xml.  singleton_begin("size_store_queue                "); xml.attribut("value",toString(_size_store_queue [i])); xml.singleton_end();
	xml.  singleton_begin("size_load_queue                 "); xml.attribut("value",toString(_size_load_queue  [i])); xml.singleton_end();
	xml. balise_close();
      }
    xml.balise_close();

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters & x)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
