/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::msg_error"
  std::string Parameters::msg_error(void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    std::string msg = "";

    if (_nb_general_register <= _nb_thread*_nb_general_register_logic)
      msg += "  - The number of physical general register is insufficient.\n";
    if (_nb_special_register <= _nb_thread*_nb_special_register_logic)
      msg += "  - The number of physical special register is insufficient.\n";
    if (not is_multiple (_nb_bank, _nb_pop))
      msg += "  - Number of pop must be a multiple of number of bank.\n";
    if (not is_power2 (_nb_bank))
      msg += "  - Number of bank must be a power of 2.\n";

    if ((_priority != PRIORITY_STATIC) and
	(_priority != PRIORITY_ROUND_ROBIN))
      msg += "  - Unsupported priority scheme. Supported scheme are "+toString(PRIORITY_STATIC)+" and "+toString(PRIORITY_ROUND_ROBIN)+".\n";

    return msg;

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
