/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


#undef  FUNCTION
#define FUNCTION "Rename_select::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    XML xml ("rename_select");

    xml.balise_open("rename_select");
    xml.singleton_begin("nb_front_end         "); xml.attribut("value",toString(_nb_front_end         )); xml.singleton_end();
    xml.singleton_begin("max_branch_speculated"); xml.attribut("value",toString(_max_branch_speculated)); xml.singleton_end();
    xml.singleton_begin("size_general_data    "); xml.attribut("value",toString(_size_general_data    )); xml.singleton_end();
    xml.singleton_begin("nb_inst_rename       "); xml.attribut("value",toString(_nb_inst_rename       )); xml.singleton_end();
    xml.singleton_begin("nb_front_end_select  "); xml.attribut("value",toString(_nb_front_end_select  )); xml.singleton_end();
    xml.singleton_begin("priority             "); xml.attribut("value",toString(_priority             )); xml.singleton_end();
    xml.singleton_begin("load_balancing       "); xml.attribut("value",toString(_load_balancing       )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_front_end; i++)
      {
	xml. balise_open_begin("component");
	xml.  attribut("type","front_end");
	xml.  attribut("id"  ,toString(i));
	xml. balise_open_end();
	xml.  singleton_begin("nb_context           "); xml.attribut("value",toString(_nb_context           [i])); xml.singleton_end();
	xml.  singleton_begin("nb_inst_decod        "); xml.attribut("value",toString(_nb_inst_decod        [i])); xml.singleton_end();
	xml. balise_close();
      }
    xml.balise_close();

    log_printf(FUNC,Rename_select,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Rename_select::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters & x)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Rename_select,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
