#ifndef RAMLOCK_H
#define RAMLOCK_H

#include <stdint.h>
#include <iostream>

using namespace std;

namespace hierarchy_memory {
namespace ramlock          {

  const static bool UNLOCK = false;
  const static bool LOCK   = true;

  class param_t
  {
  public : char   * name;
  public : uint32_t size;

  public : param_t () {};

  public : param_t (char   * name,
		    uint32_t size)
    {
      this->name = name;
      this->size = size;
    }
  };

  class Ramlock
  {
  private   : char           * name;
  protected : bool           * lock;
  protected : const uint32_t   size;

  public : Ramlock (param_t param):
    size    (param.size)
    {
      uint32_t size_name = strlen(param.name)+1;
      name = new char [size_name];
      strncpy(name,param.name,size_name);
      lock   = new bool          [size];
    }
    
    // *****[ reset ]*****
  public : void reset ()
    {
      for (uint32_t it = 0; it < size; it ++)
	lock [it] = UNLOCK;
    }

    // *****[ test ]*****
  public : bool test (uint32_t num_lock)
    {
      return num_lock < size;
    }

    // *****[ read ]*****
    // return the value of the lock and take this
    // NOTE : the caller must test if the num_lock is < size
  public : bool read (uint32_t num_lock)
    {
      bool val = lock [num_lock];
      lock [num_lock] = LOCK;
      
      return val;
    }

    // *****[ write ]*****
    // return the value of the lock and untake this
    // NOTE : the caller must test if the num_lock is < size
  public : bool write (uint32_t num_lock)
    {
      bool val = lock [num_lock];
      lock [num_lock] = UNLOCK;
      
      return val;
    }

  public    : friend ostream& operator<< (ostream& output_stream, const Ramlock & x)
      {
	output_stream << "<" << x.name << ">" << endl;
	output_stream << " * size        : " << x.size      << endl;
	
	for (uint32_t it = 0; it < x.size; it ++)
	  {
	    if (it % 32 == 0)
	      output_stream << endl;

	    output_stream << x.lock [it] << " ";
	  }
	output_stream << endl;

	return output_stream;
      };
  };

};}; //end namespace
#endif //!RAMLOCK_H
