#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Types_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

  typedef enum
    {
      IFETCH_QUEUE_STATE_EMPTY         ,  // slot is empty
    //IFETCH_QUEUE_STATE_WAIT_REQ      ,  // slot is allocated               - wait request to   cache
      IFETCH_QUEUE_STATE_WAIT_RSP      ,  // slot have send a request        - wait respons from cache
      IFETCH_QUEUE_STATE_HAVE_RSP      ,  // slot have a bloc of instruction - wait accept by decod
      IFETCH_QUEUE_STATE_ERROR_WAIT_RSP   // A event occure -> flush the queue but, ack rsp
    } ifetch_queue_state_t;

  class ifetch_queue_entry_t
  {
  public : ifetch_queue_state_t   _state                      ;
  public : Tinstruction_t       * _instruction                ;
  public : Tcontrol_t           * _instruction_enable         ;
  public : Tgeneral_address_t     _address                    ;
  public : Tinst_ifetch_ptr_t     _inst_ifetch_ptr            ;
  public : Tbranch_state_t        _branch_state               ;
  public : Tprediction_ptr_t      _branch_update_prediction_id;
  public : Texception_t           _exception                  ;
    
  public : ifetch_queue_entry_t (uint32_t nb_instruction)
    {
      _instruction        = new Tinstruction_t [nb_instruction];
      _instruction_enable = new Tcontrol_t     [nb_instruction];
    }

  public : ~ifetch_queue_entry_t (void)
    {
      delete _instruction       ;
      delete _instruction_enable;
    }

//   public : friend std::ostream& operator<< (std::ostream& output,
// 					    ifetch_queue_entry_t & x)
//     {
//       output << ;
//       return output;
//     }

  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
