#ifndef morpheo_behavioural_generic_victim_victim_pseudo_lru_Type_h
#define morpheo_behavioural_generic_victim_victim_pseudo_lru_Type_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  class entry_t
  {
    // Numerotation of victim_pseudo_lru's tree
    // Tree of Pseudo-LRU
    //
    // | d2              [3]                 |
    // |          0_______|_______1	     |
    // |          |               |	     |
    // | d1      [1]             [5]         |
    // |      0___|___1       0___|___1      |
    // |      |       |       |       |      |
    // | d0  [0]     [2]     [4]     [6]     |
    // |    0_|_1   0_|_1   0_|_1   0_|_1    |
    // |    |   |   |   |   |   |   |   |    |
    // |   Way Way Way Way Way Way Way Way   |
    // |    0   1   2   3   4   5   6   7    |
    //
    // Access :  Way N with N=2*n   -> bit 2*n = 0
    //                 with N=2*n+1 -> bit 2*n = 1
    //
    // if bit = B, depth = D, next_B = B+D if B==1
    //                               = B-D if B==0
    //
    // Update : 

  private : bool    * _entry;
  private : uint32_t  _size;
    
  public  : entry_t () 
    {
    };
  public  : entry_t (uint32_t size) : _size (size)
    {
      _entry = new bool [size];
      
      // initialisation
      for (uint32_t i=0; i<size; i++)
	_entry [i] = false;
    }
    
  public : ~entry_t ()
    {
      delete _entry;
    }
    
  private : uint32_t one_access (uint32_t index, uint32_t offset)
    {
      bool val = _entry[index];
      
      // Compute next slot
      if (val == true)
	return index + offset;
      else
	return index - offset;
    }

  public : uint32_t access ()
    {
      uint32_t index = (_size>>1)-1; // middle

      for (int32_t i=static_cast<uint32_t>(log2(_size)-1); i>= 1; i--)
	{
	  index = one_access (index,(1<<(i-1)));
	}
      index = one_access (index,0);
      
      // reverse by one_access make always a reverse
      uint32_t offset = (_entry[index]==true)?1:0; 

      return index+offset;
    }

  private : uint32_t one_update (uint32_t index, uint32_t offset, uint32_t value)
    {
      uint32_t mask = (offset==0)?1:(offset<<1);
      bool     val  = ((value & mask) != 0);

      // reverse 
      _entry[index] = not val;

      if (val == true)
      // Compute next slot
	return index + offset;
      else
	return index - offset;
    }
  public : void update (uint32_t value)
    {
      uint32_t index = (_size>>1)-1; // middle

      for (int32_t i=static_cast<uint32_t>(log2(_size)-1); i>=1; i--)
	{
	  index = one_update (index,1<<(i-1),value);
	}
      index = one_update (index,0,value);
    }

  public : std::string print ()
    {
      std::string res = "";

      for (int32_t i=static_cast<int32_t>(_size)-1; i>=0; i--)
	res += toString(_entry[i]) + " ";

      return res;
    }
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
