/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::Parameters"
  Parameters::Parameters (uint32_t size_read_queue         ,
			  uint32_t size_reservation_station,
			  uint32_t nb_context              ,
			  uint32_t nb_front_end            ,
			  uint32_t nb_ooo_engine           ,
			  uint32_t nb_packet               ,
			  uint32_t size_general_data       ,
			  uint32_t size_special_data       ,
			  uint32_t nb_general_register     ,
			  uint32_t nb_special_register     ,
			  uint32_t nb_gpr_write            ,
			  uint32_t nb_spr_write            ,
			  uint32_t size_store_queue        ,
			  uint32_t size_load_queue         ,
			  uint32_t nb_inst_retire          ,
			  uint32_t nb_bypass_write         ,
			  uint32_t nb_bypass_memory        ):
    _size_read_queue          (size_read_queue         ),
    _size_reservation_station (size_reservation_station),
    _nb_context               (nb_context              ),
    _nb_front_end             (nb_front_end            ),
    _nb_ooo_engine            (nb_ooo_engine           ),
    _nb_packet                (nb_packet               ),
    _size_general_data        (size_general_data       ),
    _size_special_data        (size_special_data       ),
    _nb_general_register      (nb_general_register     ),
    _nb_special_register      (nb_special_register     ),
    _nb_gpr_write             (nb_gpr_write            ),
    _nb_spr_write             (nb_spr_write            ),
    _size_store_queue         (size_store_queue        ),
    _size_load_queue          (size_load_queue         ),
    _nb_inst_retire           (nb_inst_retire          ),
    _nb_bypass_write          (nb_bypass_write         ),
    _nb_bypass_memory         (nb_bypass_memory        ),
    
    _nb_gpr_read              (2),
    _nb_spr_read              (1),    
    _size_context_id          (log2(nb_context         )),
    _size_front_end_id        (log2(nb_front_end       )),
    _size_ooo_engine_id       (log2(nb_ooo_engine      )),
    _size_packet_id           (log2(nb_packet          )),
    _size_general_register    (log2(nb_general_register)),
    _size_special_register    (log2(nb_special_register)),
    
    _have_port_context_id     (_size_context_id   >0),
    _have_port_front_end_id   (_size_front_end_id >0),
    _have_port_ooo_engine_id  (_size_ooo_engine_id>0),
    _have_port_packet_id      (_size_packet_id    >0),
    _have_port_load_queue_ptr (_size_load_queue   >1)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    _param_read_queue = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Parameters
      ( _size_read_queue    
	,_nb_context         
	,_nb_front_end       
	,_nb_ooo_engine
	,_nb_packet          
	,_size_general_data  
	,_size_special_data  
	,_nb_general_register
	,_nb_special_register
	,_nb_gpr_write
	,_nb_spr_write
	,_size_store_queue
	,_size_load_queue 
	);

    _param_reservation_station = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters
	(size_reservation_station
	 ,nb_inst_retire     
	 ,nb_context         
	 ,nb_front_end       
	 ,nb_ooo_engine
	 ,nb_packet          
	 ,size_general_data  
	 ,size_special_data  
	 ,nb_general_register
	 ,nb_special_register
	 ,nb_gpr_write
	 ,nb_spr_write
	 ,nb_bypass_write 
	 ,nb_bypass_memory
	 ,size_store_queue
	 ,size_load_queue 
	 );


    test();

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Read_unit::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _size_read_queue          (param._size_read_queue         ),
    _size_reservation_station (param._size_reservation_station),
    _nb_context               (param._nb_context              ),
    _nb_front_end             (param._nb_front_end            ),
    _nb_ooo_engine            (param._nb_ooo_engine           ),
    _nb_packet                (param._nb_packet               ),
    _size_general_data        (param._size_general_data       ),
    _size_special_data        (param._size_special_data       ),
    _nb_general_register      (param._nb_general_register     ),
    _nb_special_register      (param._nb_special_register     ),
    _nb_gpr_write             (param._nb_gpr_write            ),
    _nb_spr_write             (param._nb_spr_write            ),
    _size_store_queue         (param._size_store_queue        ),
    _size_load_queue          (param._size_load_queue         ),
    _nb_inst_retire           (param._nb_inst_retire          ),
    _nb_bypass_write          (param._nb_bypass_write         ),
    _nb_bypass_memory         (param._nb_bypass_memory        ),

    _nb_gpr_read              (param._nb_gpr_read             ),
    _nb_spr_read              (param._nb_spr_read             ),    
    _size_context_id          (param._size_context_id         ),
    _size_front_end_id        (param._size_front_end_id       ),
    _size_ooo_engine_id       (param._size_ooo_engine_id      ),
    _size_packet_id           (param._size_packet_id          ),
    _size_general_register    (param._size_general_register   ),
    _size_special_register    (param._size_special_register   ),

    _have_port_context_id     (param._have_port_context_id    ),
    _have_port_front_end_id   (param._have_port_front_end_id  ),
    _have_port_ooo_engine_id  (param._have_port_ooo_engine_id ),
    _have_port_packet_id      (param._have_port_packet_id     ),
    _have_port_load_queue_ptr (param._have_port_load_queue_ptr)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    _param_read_queue          = param._param_read_queue         ;
    _param_reservation_station = param._param_reservation_station;

    test();

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Read_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    delete _param_read_queue;
    delete _param_reservation_station;

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
