/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::Execute_queue"
  Execute_queue::Execute_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    log_printf(INFO,Execute_queue,FUNCTION,"Allocation");
    allocation ();

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Execute_queue,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Execute_queue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	log_printf(INFO,Execute_queue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Execute_queue,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Execute_queue::~Execute_queue"
  Execute_queue::~Execute_queue (void)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Execute_queue,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Execute_queue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
