#ifdef STATISTICS
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::statistics_allocation"
  void Ifetch_queue::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Ifetch_queue",
		      param_statistics);

    _sum_transaction_address      = _stat->create_variable("sum_transaction_address");

    _sum_use_queue                = _stat->create_variable("sum_use_queue");
    _sum_use_queue_wait_rsp       = _stat->create_variable("sum_use_queue_wait_rsp");
    _sum_use_queue_have_rsp       = _stat->create_variable("sum_use_queue_have_rsp");
    _sum_use_queue_error_wait_rsp = _stat->create_variable("sum_use_queue_error_wait_rsp");
    _sum_inst_enable              = _stat->create_variable("sum_inst_enable");

    _average_occupation_bundle    = _stat->create_counter ("average_occupation_bundle", "", "Occupation average of instruction's bundle.");

    _stat->create_expr                 ("average_occupation_bundle" ,"/ sum_inst_enable sum_transaction_address");
    _stat->create_expr_percent         ("percent_occupation_bundle" ,"average_occupation_bundle", toString(_param->_nb_instruction),"Percent of instruction's bundle occupation.");
    _stat->create_expr                 ("sum_use_queue"             ,"+ + sum_use_queue_wait_rsp sum_use_queue_have_rsp sum_use_queue_error_wait_rsp");
    _stat->create_expr_average_by_cycle("average_use_queue"               ,"sum_use_queue"               ,"","Average occupation of ifetch queue");
    _stat->create_expr_percent         ("percent_use_queue"               ,"average_use_queue"           ,toString(_param->_size_queue),"Percent of occupation of ifetch queue");
    _stat->create_expr_percent         ("percent_use_queue_wait_rsp"      ,"sum_use_queue_wait_rsp"      ,"sum_use_queue","Part of ifetch queue that wait the respons icache");
    _stat->create_expr_percent         ("percent_use_queue_have_rsp"      ,"sum_use_queue_have_rsp"      ,"sum_use_queue","Part of ifetch queue that wait the decod");
    _stat->create_expr_percent         ("percent_use_queue_error_wait_rsp","sum_use_queue_error_wait_rsp","sum_use_queue","Part of ifetch queue that have an error and wait the respons icache");

    _stat->create_expr_average         ("average_miss_icache"             ,"+ sum_use_queue_wait_rsp sum_use_queue_error_wait_rsp", "sum_transaction_address", "", "Average Miss Instruction Cache");

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
