/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/SelfTest/include/test.h"

#define NB_PARAMS 8

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context      (uint32_t)\n"));
  err (_(" * size_buffer     (uint32_t)\n"));
  err (_(" * associativity   (uint32_t)\n"));
  err (_(" * size_address    (uint32_t)\n"));
  err (_(" * size_counter    (uint32_t)\n"));
  err (_(" * nb_inst_predict (uint32_t)\n"));
  err (_(" * nb_inst_decod   (uint32_t)\n"));
  err (_(" * nb_inst_commit  (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t   _nb_context      = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_context))
    usage (argc, argv);

  uint32_t * _nb_instruction  = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _nb_instruction [i] = fromString<uint32_t>(argv[x++]);

  uint32_t   _size_buffer     = fromString<uint32_t>(argv[x++]);
  uint32_t   _associativity   = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_address    = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_counter    = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_predict = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_decod   = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_commit  = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters
	(_nb_context     ,
	 _nb_instruction ,
	 _size_buffer    ,
	 _associativity  ,
	 _size_address   ,
	 _size_counter   ,
	 _nb_inst_predict,
	 _nb_inst_decod  ,
	 _nb_inst_commit );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete _nb_instruction;

  return (_return);
}
