/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Dependency_checking_unit/include/Dependency_checking_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace dependency_checking_unit {


#undef  FUNCTION
#define FUNCTION "Dependency_checking_unit::Dependency_checking_unit"
  Dependency_checking_unit::Dependency_checking_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::dependency_checking_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"Begin");

    log_printf(INFO,Dependency_checking_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Dependency_checking_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Dependency_checking_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)

	log_printf(INFO,Dependency_checking_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
#  ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
#  endif    
# endif

	log_printf(INFO,Dependency_checking_unit,FUNCTION,"Method - genMealy");
	
	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0;i<_param->_nb_inst_insert; i++)
	  {
	    sensitive // << (*(in_RENAME_IN_VAL                [i]))
// 		      << (*(in_RENAME_OUT_ACK               [i]))
		      << (*(in_RENAME_IN_READ_RA            [i]))
		      << (*(in_RENAME_IN_NUM_REG_RA_LOG     [i]))
		      << (*(in_RENAME_IN_NUM_REG_RA_PHY     [i]))
		      << (*(in_RENAME_IN_READ_RB            [i]))
		      << (*(in_RENAME_IN_NUM_REG_RB_LOG     [i]))
		      << (*(in_RENAME_IN_NUM_REG_RB_PHY     [i]))
		      << (*(in_RENAME_IN_READ_RC            [i]))
		      << (*(in_RENAME_IN_NUM_REG_RC_LOG     [i]))
		      << (*(in_RENAME_IN_NUM_REG_RC_PHY     [i]))
		      << (*(in_RENAME_IN_WRITE_RD           [i]))
		      << (*(in_RENAME_IN_NUM_REG_RD_LOG     [i]))
		      << (*(in_RENAME_IN_NUM_REG_RD_PHY_OLD [i]))
		      << (*(in_RENAME_IN_NUM_REG_RD_PHY_NEW [i]))
		      << (*(in_RENAME_IN_WRITE_RE           [i]))
		      << (*(in_RENAME_IN_NUM_REG_RE_LOG     [i]))
		      << (*(in_RENAME_IN_NUM_REG_RE_PHY_OLD [i]))
		      << (*(in_RENAME_IN_NUM_REG_RE_PHY_NEW [i]));
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_RENAME_IN_FRONT_END_ID       [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_RENAME_IN_CONTEXT_ID         [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0;i<_param->_nb_inst_insert; i++)
	  {
// 	    (*(out_RENAME_OUT_VAL                [i])) (*(in_RENAME_IN_VAL                [i]));
// 	    (*(out_RENAME_IN_ACK                 [i])) (*(in_RENAME_OUT_ACK               [i]));
	    if (_param->_have_port_front_end_id)
	    (*(out_RENAME_OUT_FRONT_END_ID       [i])) (*(in_RENAME_IN_FRONT_END_ID       [i]));
	    if (_param->_have_port_context_id)
	    (*(out_RENAME_OUT_CONTEXT_ID         [i])) (*(in_RENAME_IN_CONTEXT_ID         [i]));
	    (*(out_RENAME_OUT_READ_RA            [i])) (*(in_RENAME_IN_READ_RA            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RA_LOG     [i])) (*(in_RENAME_IN_NUM_REG_RA_LOG     [i]));
	    (*(out_RENAME_OUT_READ_RB            [i])) (*(in_RENAME_IN_READ_RB            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RB_LOG     [i])) (*(in_RENAME_IN_NUM_REG_RB_LOG     [i]));
	    (*(out_RENAME_OUT_READ_RC            [i])) (*(in_RENAME_IN_READ_RC            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RC_LOG     [i])) (*(in_RENAME_IN_NUM_REG_RC_LOG     [i]));
	    (*(out_RENAME_OUT_WRITE_RD           [i])) (*(in_RENAME_IN_WRITE_RD           [i]));
	    (*(out_RENAME_OUT_NUM_REG_RD_LOG     [i])) (*(in_RENAME_IN_NUM_REG_RD_LOG     [i]));
	    (*(out_RENAME_OUT_NUM_REG_RD_PHY_NEW [i])) (*(in_RENAME_IN_NUM_REG_RD_PHY_NEW [i]));
	    (*(out_RENAME_OUT_WRITE_RE           [i])) (*(in_RENAME_IN_WRITE_RE           [i]));
	    (*(out_RENAME_OUT_NUM_REG_RE_LOG     [i])) (*(in_RENAME_IN_NUM_REG_RE_LOG     [i]));
	    (*(out_RENAME_OUT_NUM_REG_RE_PHY_NEW [i])) (*(in_RENAME_IN_NUM_REG_RE_PHY_NEW [i]));

	    (*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RD_PHY_OLD [i]));
	    (*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_WRITE_RD           [i]));
	    (*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RD_LOG     [i]));
	    for (int32_t j=i-1; j>=0; j--)
	      {
		if (_param->_have_port_front_end_id)
		(*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_FRONT_END_ID       [j]));
		if (_param->_have_port_context_id)
		(*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_CONTEXT_ID         [j]));
		(*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_WRITE_RD           [j]));
		(*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RD_LOG     [j]));
		(*(out_RENAME_OUT_NUM_REG_RD_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RD_PHY_NEW [j]));
	      }

	    (*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RE_PHY_OLD [i]));
	    (*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_WRITE_RE           [i]));
	    (*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RE_LOG     [i]));
	    for (int32_t j=i-1; j>=0; j--)
	      {
		if (_param->_have_port_front_end_id)
		(*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_FRONT_END_ID       [j]));
		if (_param->_have_port_context_id)
		(*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_CONTEXT_ID         [j]));
		(*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_WRITE_RE           [j]));
		(*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RE_LOG     [j]));
		(*(out_RENAME_OUT_NUM_REG_RE_PHY_OLD [i])) (*(in_RENAME_IN_NUM_REG_RE_PHY_NEW [j]));
	      }

	    (*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RA_PHY     [i]));
	    (*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_READ_RA            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RA_LOG     [i]));
	    for (int32_t j=i-1; j>=0; j--)
	      {
		if (_param->_have_port_front_end_id)
		(*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_FRONT_END_ID       [j]));
		if (_param->_have_port_context_id)
		(*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_CONTEXT_ID         [j]));
		(*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_WRITE_RD           [j]));
		(*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RD_LOG     [j]));
		(*(out_RENAME_OUT_NUM_REG_RA_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RD_PHY_NEW [j]));
	      }

	    (*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RB_PHY     [i]));
	    (*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_READ_RB            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RB_LOG     [i]));
	    for (int32_t j=i-1; j>=0; j--)
	      {
		if (_param->_have_port_front_end_id)
		(*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_FRONT_END_ID       [j]));
		if (_param->_have_port_context_id)
		(*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_CONTEXT_ID         [j]));
		(*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_WRITE_RD           [j]));
		(*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RD_LOG     [j]));
		(*(out_RENAME_OUT_NUM_REG_RB_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RD_PHY_NEW [j]));
	      }

	    (*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RC_PHY     [i]));
	    (*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_READ_RC            [i]));
	    (*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RC_LOG     [i]));
	    for (int32_t j=i-1; j>=0; j--)
	      {
		if (_param->_have_port_front_end_id)
		(*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_FRONT_END_ID       [j]));
		if (_param->_have_port_context_id)
		(*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_CONTEXT_ID         [j]));
		(*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_WRITE_RE           [j]));
		(*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RE_LOG     [j]));
		(*(out_RENAME_OUT_NUM_REG_RC_PHY     [i])) (*(in_RENAME_IN_NUM_REG_RE_PHY_NEW [j]));
	      }
	  }
# endif    

      }
#endif
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Dependency_checking_unit::~Dependency_checking_unit"
  Dependency_checking_unit::~Dependency_checking_unit (void)
  {
    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	log_printf(INFO,Dependency_checking_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Dependency_checking_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Dependency_checking_unit,FUNCTION,"End");
  };

}; // end namespace dependency_checking_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
