#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


  void Counter::allocation (void)
  {
    log_printf(FUNC,Counter,"allocation","Begin");

    _component   = new Component ();

    Entity * entity = _component->set_entity (_name     
					     ,"Counter"  
#ifdef POSITION
					     ,COMBINATORY
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN  
							 , SOUTH
							 , "Generalist interface"
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1,CLOCK_VHDL_NO);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1,RESET_VHDL_NO);
    }

    // ~~~~~[Interface : "counter" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
        in_COUNTER_DATA  = new SC_IN (Tdata_t)    * [_param._nb_port];
        in_COUNTER_ADDSUB= new SC_IN (Tcontrol_t) * [_param._nb_port];
       out_COUNTER_DATA  = new SC_OUT(Tdata_t)    * [_param._nb_port];
       
       for (uint32_t i=0; i<_param._nb_port; i++)
	 {
	   Interface_fifo * interface = _interfaces->set_interface("counter_"+toString(i)
#ifdef POSITION
								   , IN  
								   , SOUTH
								   , "Counter interface"
#endif
								   );
	   
	    in_COUNTER_DATA   [i] = interface->set_signal_in  <Tdata_t   > ("data"  , _param._size_data);
	    in_COUNTER_ADDSUB [i] = interface->set_signal_in  <Tcontrol_t> ("addsub", 1                );
	   out_COUNTER_DATA   [i] = interface->set_signal_out <Tdata_t   > ("data"  , _param._size_data);
	 }
     }
#ifdef POSITION
    _component->generate_file();
#endif

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    log_printf(FUNC,Counter,"allocation","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
