#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {

#define string2operator(x) (x=="+")?add:((x=="-")?sub:((x=="*")?mul:((x=="/" )?div:((x=="++")?inc:dec))))

  Stat_binary_tree * Stat::string2tree     (std::string expr)
  {
    const std::string delims  (" ");          // dlimiteur : " "
    const std::string numbers ("0123456789"); // dlimiteur : " "
    std::string::size_type index_begin, index_end;

    Stat_binary_tree * tree = NULL;

    index_begin = expr.find_first_not_of(delims);

    while (index_begin != std::string::npos)
      {
	index_end = expr.find_first_of(delims, index_begin);

	if (index_end == std::string::npos)
	  {
	    index_end = expr.length();
	  }
	
	std::string str = expr.substr(index_begin, index_end-index_begin);
	
	// 3 possibilits :
	//  * operator
	//  * constante
	//  * variable
	{
	  // Test constantes
	  std::string::size_type index = str.find_first_not_of(numbers);
	  if (index  == std::string::npos)
	    {
// 	      std::cout << " * c'est une constante." << std::endl; 

	      if (tree==NULL)
		tree = new Stat_binary_tree (atoi(str.c_str()));
	      else
		tree = tree->insert_tree (atoi(str.c_str()));
	    }
	  else
	    {
	      // Test variables
	      std::map<std::string, var_t>::iterator it = _list_operand->find(str);
	      if (it != _list_operand->end())
		{
// 		  std::cout << " * c'est une variable." << std::endl; 

		  if (tree==NULL)
		    tree = new Stat_binary_tree (it->second.counter);
		  else
		    tree = tree->insert_tree (it->second.counter);
		}
	      else
		{
		  if ((str == "+") or
		      (str == "-") or
		      (str == "*") or
		      (str == "/"))
		    {
// 		      std::cout << " * c'est un operator  2 oprandes." << std::endl; 
		      
// 		      if (tree==NULL)
// 			tree = new Stat_binary_tree (morpheo::string2operator[str].second);
// 		      else
// 			tree->insert_tree (morpheo::string2operator[str].second);
		      if (tree==NULL)
			tree = new Stat_binary_tree (string2operator(str));
		      else
			tree = tree->insert_tree (string2operator(str));
		    }
		  else
		    {
		      if ((str == "++") or
			  (str == "--"))
			{
// 			  std::cout << " * c'est un operator  1 oprande." << std::endl; 

// 			  if (tree==NULL)
// 			    tree = new Stat_binary_tree (string2operator[str.c_str()]);
// 			  else
// 			    tree->insert_tree (string2operator[str.c_str()]);

			  if (tree==NULL)
			    tree = new Stat_binary_tree (string2operator(str));
			  else
			    tree = tree->insert_tree (string2operator(str));
			  
			}
		      else
			{
// 			  std::cout << " * c'est autre chose." << std::endl; 
			  str = "expression '"+str+"' doesn't a constant, a declarated variable or an operator.";
			  throw(ERRORMORPHEO("Stat::string2tree",_(str.c_str())));
			}
		    }
		}
	    }
	}

	index_begin = expr.find_first_not_of(delims, index_end);

	if (index_begin != std::string::npos)
	  tree = tree->goto_next_root();
      }

    if (tree == NULL)
      throw (ERRORMORPHEO("Stat::string2tree",_("the tree generated is empty.")));

//     std::cout << "<Stat::string2tree> goto_top_level" << std::endl;

    tree = tree->goto_top_level();

//     std::cout << "<Stat::string2tree> valid" << std::endl;

    if (not tree->valid())
      throw (ERRORMORPHEO("Stat::string2tree",_("the tree generated is invalid.")));

//     std::cout << "<Stat::string2tree> End" << std::endl;

    return tree;

  }
  
};
};
#endif
