/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    XML xml ("return_address_stack");

    xml.balise_open("return_address_stack");
    xml.singleton_begin("nb_context     "); xml.attribut("value",toString(_nb_context     )); xml.singleton_end();
    xml.singleton_begin("size_address   "); xml.attribut("value",toString(_size_address   )); xml.singleton_end();
    xml.singleton_begin("nb_inst_predict"); xml.attribut("value",toString(_nb_inst_predict)); xml.singleton_end();
    xml.singleton_begin("nb_inst_decod  "); xml.attribut("value",toString(_nb_inst_decod  )); xml.singleton_end();
    xml.singleton_begin("nb_inst_update "); xml.attribut("value",toString(_nb_inst_update )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_context; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","context");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
	xml.  singleton_begin("size_queue     "); xml.attribut("value",toString(_size_queue [i])); xml.singleton_end();
        xml. balise_close();
      }
    xml.balise_close();

    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack::Parameters & x)
  {
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Return_Address_Stack,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
