#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Load_Store_pointer_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::genMealy_insert"
  void Load_Store_pointer_unit::genMealy_insert (void)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    bool use_lsq [_param->_nb_load_store_queue];
    for (uint32_t i=0; i<_param->_nb_load_store_queue; i++)
      use_lsq [i] = false;

    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	Tcontrol_t ack                   = false;
	Tlsq_ptr_t store_queue_ptr_write = 0;
	Tlsq_ptr_t load_queue_ptr_write  = 0;

	if ( (PORT_READ(in_INSERT_VAL  [i]) == true       ) and
	     (PORT_READ(in_INSERT_TYPE [i]) == TYPE_MEMORY))
	  {
	    Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_INSERT_FRONT_END_ID [i]):0;
	    Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_INSERT_CONTEXT_ID   [i]):0;
	    
	    uint32_t   lsq          = _param->_link_load_store_unit_with_thread[front_end_id][context_id];

	    // Test if a previous instruction use the same lsq
	    // Authorize once memory access by load store unit
	    if (use_lsq [lsq] == false)
	      {
		use_lsq [lsq] = true;

		uint32_t   ptr;
		
		store_queue_ptr_write   = reg_STORE_QUEUE_PTR_WRITE [lsq];
		load_queue_ptr_write    = reg_LOAD_QUEUE_PTR_WRITE  [lsq];
		
		// operation became of decod_stage. Also operation is != store_head_ok and store_head_ko
		if (is_operation_memory_store(PORT_READ(in_INSERT_OPERATION [i])))
		  {
		    internal_INSERT_OPERATION_USE [i] = OPERATION_USE_STORE_QUEUE;
		    
		    ptr = reg_STORE_QUEUE_PTR_WRITE [lsq];

		    ack = not reg_STORE_QUEUE_USE [lsq][ptr] and (static_cast<uint32_t>(reg_STORE_QUEUE_NB_USE [lsq]+1) < _param->_size_store_queue[lsq]);
		  }
		else
		  {
		    internal_INSERT_OPERATION_USE [i] = OPERATION_USE_LOAD_QUEUE;
		    
		    ptr = reg_LOAD_QUEUE_PTR_WRITE [lsq];

		    ack = (not reg_LOAD_QUEUE_USE [lsq][ptr]);
		  }
		
		internal_INSERT_LSQ [i] = lsq;
		internal_INSERT_PTR [i] = ptr;
	      }
	  }
	else
	  {
	    ack = true;

	    internal_INSERT_OPERATION_USE [i] = OPERATION_USE_NONE;
	  }

	// Write output
	internal_INSERT_ACK [i] = ack;
	PORT_WRITE(out_INSERT_ACK                   [i], ack);
	PORT_WRITE(out_INSERT_STORE_QUEUE_PTR_WRITE [i], store_queue_ptr_write);
	if (_param->_have_port_load_queue_ptr)
	PORT_WRITE(out_INSERT_LOAD_QUEUE_PTR_WRITE  [i], load_queue_ptr_write );
      }

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
