#include "Behavioural/include/SPR_access_mode.h"

namespace morpheo {
namespace behavioural {

  bool SPR_access_mode::valid (spr_address_t address)
  {
    return valid(address._group, address._register);
  }
  
  bool SPR_access_mode::valid (uint32_t num_group, uint32_t num_reg)
  {
//     std::cout << "<SPR_access_mode::valid>" << std::endl;
//     std::cout << "  * num_group                         : " << num_group << std::endl;
//     std::cout << "  * num_reg                           : " << num_reg   << std::endl;
//     std::cout << "  * _spr_generic          [num_group] : " << _spr_generic[num_group] << std::endl;
//     std::cout << "  * _max_register_by_group[num_group] : " << _max_register_by_group[num_group] << std::endl;
    return ((num_group < NB_GROUP) and (_spr_generic[num_group] != NULL) and (num_reg < _max_register_by_group[num_group]));
  }

}; // end namespace behavioural
}; // end namespace morpheo              

