#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_network_execution_unit_to_write_unit_Execution_unit_to_Write_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_network_execution_unit_to_write_unit_Execution_unit_to_Write_unit_h

/*
 * $Id: Execution_unit_to_Write_unit.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Identification.h"

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


  class Execution_unit_to_Write_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "execute_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_UNIT_OUT_VAL            ;
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_UNIT_OUT_ACK            ;
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_UNIT_OUT_CONTEXT_ID     ;
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_UNIT_OUT_FRONT_END_ID   ;
  public    : SC_IN (Tcontext_t        )   **  in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID  ;
  public    : SC_IN (Tpacket_t         )   **  in_EXECUTE_UNIT_OUT_PACKET_ID      ;
//public    : SC_IN (Toperation_t      )   **  in_EXECUTE_UNIT_OUT_OPERATION      ;
  public    : SC_IN (Ttype_t           )   **  in_EXECUTE_UNIT_OUT_TYPE           ;
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_UNIT_OUT_WRITE_RD       ;
  public    : SC_IN (Tgeneral_address_t)   **  in_EXECUTE_UNIT_OUT_NUM_REG_RD     ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_EXECUTE_UNIT_OUT_DATA_RD        ;
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_UNIT_OUT_WRITE_RE       ;
  public    : SC_IN (Tspecial_address_t)   **  in_EXECUTE_UNIT_OUT_NUM_REG_RE     ;
  public    : SC_IN (Tspecial_data_t   )   **  in_EXECUTE_UNIT_OUT_DATA_RE        ;
  public    : SC_IN (Texception_t      )   **  in_EXECUTE_UNIT_OUT_EXCEPTION      ;
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_UNIT_OUT_NO_SEQUENCE    ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_EXECUTE_UNIT_OUT_ADDRESS        ;

    // ~~~~~[ Interface "write_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_WRITE_UNIT_IN_VAL            ;
  public    : SC_IN (Tcontrol_t        )   **  in_WRITE_UNIT_IN_ACK            ;
  public    : SC_OUT(Tcontext_t        )   ** out_WRITE_UNIT_IN_CONTEXT_ID     ;
  public    : SC_OUT(Tcontext_t        )   ** out_WRITE_UNIT_IN_FRONT_END_ID   ;
  public    : SC_OUT(Tcontext_t        )   ** out_WRITE_UNIT_IN_OOO_ENGINE_ID  ;
  public    : SC_OUT(Tpacket_t         )   ** out_WRITE_UNIT_IN_PACKET_ID      ;
//public    : SC_OUT(Toperation_t      )   ** out_WRITE_UNIT_IN_OPERATION      ;
  public    : SC_OUT(Ttype_t           )   ** out_WRITE_UNIT_IN_TYPE           ;
  public    : SC_OUT(Tcontrol_t        )   ** out_WRITE_UNIT_IN_WRITE_RD       ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_WRITE_UNIT_IN_NUM_REG_RD     ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_WRITE_UNIT_IN_DATA_RD        ;
  public    : SC_OUT(Tcontrol_t        )   ** out_WRITE_UNIT_IN_WRITE_RE       ;
  public    : SC_OUT(Tspecial_address_t)   ** out_WRITE_UNIT_IN_NUM_REG_RE     ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_WRITE_UNIT_IN_DATA_RE        ;
  public    : SC_OUT(Texception_t      )   ** out_WRITE_UNIT_IN_EXCEPTION      ;
  public    : SC_OUT(Tcontrol_t        )   ** out_WRITE_UNIT_IN_NO_SEQUENCE    ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_WRITE_UNIT_IN_ADDRESS        ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : std::list<uint32_t> ** _destination; // [nb_execute_unit][nb_thread];
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Execution_unit_to_Write_unit);
#endif
  public  :          Execution_unit_to_Write_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Execution_unit_to_Write_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
