/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_ooo_engine                             (uint32_t)" << endl
       << " - size_general_data                         (uint32_t)" << endl
       << " - size_special_data                         (uint32_t)" << endl
       << " - nb_gpr_read                               (uint32_t)" << endl
       << " - nb_spr_read                               (uint32_t)" << endl
       << " - nb_gpr_write                              (uint32_t)" << endl
       << " - nb_spr_write                              (uint32_t)" << endl
       << " - nb_inst_insert_rob        [nb_ooo_engine] (uint32_t)" << endl 
       << " - nb_inst_retire_rob        [nb_ooo_engine] (uint32_t)" << endl 
       << "" << endl;
  
  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t     x = 1;

  string       name                 =      argv[x++];
  uint32_t    _nb_ooo_engine        = atoi(argv[x++]);
  uint32_t    _size_general_data    = atoi(argv[x++]);
  uint32_t    _size_special_data    = atoi(argv[x++]);
  uint32_t    _nb_gpr_read          = atoi(argv[x++]);
  uint32_t    _nb_spr_read          = atoi(argv[x++]);    
  uint32_t    _nb_gpr_write         = atoi(argv[x++]);
  uint32_t    _nb_spr_write         = atoi(argv[x++]);

  if (argc != 2+NB_PARAMS+static_cast<int>(2*_nb_ooo_engine))
    usage (argc, argv);
  
  uint32_t  * _nb_inst_insert_rob = new uint32_t [_nb_ooo_engine];
  uint32_t  * _nb_inst_retire_rob = new uint32_t [_nb_ooo_engine];

  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_inst_insert_rob  [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_inst_retire_rob  [i] = atoi(argv[x++]);

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Parameters
	(_nb_ooo_engine    ,
	 _size_general_data,
	 _size_special_data,
	 _nb_gpr_read      ,
	 _nb_spr_read      ,
	 _nb_gpr_write     ,
	 _nb_spr_write     ,
	 _nb_inst_insert_rob,
	 _nb_inst_retire_rob);
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

