/*
 * $Id: Execute_loop_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Execute_loop.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {



#undef  FUNCTION
#define FUNCTION "Execute_loop::allocation"
  void Execute_loop::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Execute_loop,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Execute_loop"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ Interface "execute_loop_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("execute_loop_in", IN, EAST, "Operation's Input", _param->_nb_read_unit);

       ALLOC1_VALACK_IN ( in_EXECUTE_LOOP_IN_VAL,VAL);
       ALLOC1_VALACK_OUT(out_EXECUTE_LOOP_IN_ACK,ACK);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_PACKET_ID            ,"packet_id"            ,Tpacket_t         ,_param->_size_packet_id);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type);         
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_max_size_store_queue);
       if (_param->_have_port_load_queue_ptr)
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_max_size_load_queue);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_NUM_REG_RA           ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_NUM_REG_RB           ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_NUM_REG_RC           ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_EXECUTE_LOOP_IN_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);
     }
    // ~~~~~[ Interface "execute_loop_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("execute_loop_out",OUT, EAST, "Operation's Output", _param->_nb_write_unit);

       ALLOC1_VALACK_OUT(out_EXECUTE_LOOP_OUT_VAL,VAL);
       ALLOC1_VALACK_IN ( in_EXECUTE_LOOP_OUT_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_FRONT_END_ID ,"front_end_id" ,Tcontext_t     ,_param->_size_front_end_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t     ,_param->_size_ooo_engine_id);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_PACKET_ID    ,"packet_id"    ,Tpacket_t      ,_param->_size_packet_id);
//     ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_OPERATION    ,"operation"    ,Toperation_t   ,_param->_size_operation);
//     ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_TYPE         ,"type"         ,Ttype_t        ,_param->_size_type);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_FLAGS        ,"flags"        ,Tspecial_data_t,_param->_size_special_data);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_EXCEPTION    ,"exception"    ,Texception_t   ,_param->_size_exception);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t     ,1);
       ALLOC1_SIGNAL_OUT(out_EXECUTE_LOOP_OUT_ADDRESS      ,"address"      ,Tgeneral_data_t,_param->_size_general_data);
     }
    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("dcache_req",OUT, NORTH, "Data cache port : request", _param->_nb_load_store_unit);
       
       ALLOC1_VALACK_OUT(out_DCACHE_REQ_VAL,VAL);
       ALLOC1_VALACK_IN ( in_DCACHE_REQ_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_CONTEXT_ID,"context_id",Tcontext_t       ,_param->_max_size_dcache_context_id);
       ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_PACKET_ID ,"packet_id" ,Tpacket_t        ,_param->_max_size_dcache_packet_id );
       ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_ADDRESS   ,"address"   ,Tdcache_address_t,_param->_size_general_data);
       ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_TYPE      ,"type"      ,Tdcache_type_t   ,_param->_size_dcache_type);
       ALLOC1_SIGNAL_OUT(out_DCACHE_REQ_WDATA     ,"wdata"     ,Tdcache_data_t   ,_param->_size_general_data);
     }
    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("dcache_rsp",IN, NORTH, "Data cache port : respons", _param->_nb_load_store_unit);

       ALLOC1_VALACK_IN ( in_DCACHE_RSP_VAL,VAL);
       ALLOC1_VALACK_OUT(out_DCACHE_RSP_ACK,ACK);
       ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_CONTEXT_ID,"context_id",Tcontext_t     ,_param->_max_size_dcache_context_id);
       ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_PACKET_ID ,"packet_id" ,Tpacket_t      ,_param->_max_size_dcache_packet_id);
       ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_RDATA     ,"rdata"     ,Tdcache_data_t ,_param->_size_general_data);
       ALLOC1_SIGNAL_IN ( in_DCACHE_RSP_ERROR     ,"error"     ,Tdcache_error_t,_param->_size_dcache_error);
     }
    // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC2_INTERFACE("insert_rob",IN, EAST, "Rename's stage : insert a new instruction in the Re Order Buffer",_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_interface_it1]);
       
       _ALLOC2_VALACK_IN ( in_INSERT_ROB_VAL,VAL,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
       _ALLOC2_VALACK_OUT(out_INSERT_ROB_ACK,ACK,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);

       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RD_USE    ,"rd_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RD_NUM_REG,"rd_num_reg",Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RE_USE    ,"re_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RE_NUM_REG,"re_num_reg",Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
     }
    // ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC2_INTERFACE("retire_rob",IN, EAST, "Rename's stage : retire a new instruction in the Re Order Buffer",_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_interface_it1]);
       
       _ALLOC2_VALACK_IN ( in_RETIRE_ROB_VAL,VAL,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_VALACK_OUT(out_RETIRE_ROB_ACK,ACK,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);

       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RD_OLD_USE    ,"rd_old_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RD_OLD_NUM_REG,"rd_old_num_reg",Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RD_NEW_USE    ,"rd_new_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RD_NEW_NUM_REG,"rd_new_num_reg",Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RE_OLD_USE    ,"re_old_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RE_OLD_NUM_REG,"re_old_num_reg",Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RE_NEW_USE    ,"re_new_use"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
       _ALLOC2_SIGNAL_IN ( in_RETIRE_ROB_RE_NEW_NUM_REG,"re_new_num_reg",Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
     }

     // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     std::string name;
	
     _component_read_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Read_unit * [_param->_nb_read_unit];
     for (uint32_t i=0; i<_param->_nb_read_unit; i++)
       {
	 name = _name+"_read_unit_"+toString(i);
	 std::cout << "Create   : " << name << std::endl;

	 _component_read_unit [i] = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Read_unit
	   (name.c_str()
#ifdef STATISTICS
	    ,param_statistics
#endif
	    ,_param->_param_read_unit[i]);

	 _component->set_component (_component_read_unit [i]->_component
#ifdef POSITION
				    , 50, 50, 10, 10
#endif
				    );
       }

     _component_functionnal_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Functionnal_unit * [_param->_nb_functionnal_unit];
     for (uint32_t i=0; i<_param->_nb_functionnal_unit; i++)
       {
	 name = _name+"_functionnal_unit_"+toString(i);
	 std::cout << "Create   : " << name << std::endl;

	 _component_functionnal_unit [i] = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Functionnal_unit
	   (name.c_str()
#ifdef STATISTICS
	    ,param_statistics
#endif
	    ,_param->_param_functionnal_unit[i]);

	 _component->set_component (_component_functionnal_unit [i]->_component
#ifdef POSITION
				    , 50, 50, 10, 10
#endif
				    );
       }

     _component_load_store_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit * [_param->_nb_load_store_unit];
     for (uint32_t i=0; i<_param->_nb_load_store_unit; i++)
       {
	 name = _name+"_load_store_unit_"+toString(i);
	 std::cout << "Create   : " << name << std::endl;

	 _component_load_store_unit [i] = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit
	   (name.c_str()
#ifdef STATISTICS
	    ,param_statistics
#endif
	    ,_param->_param_load_store_unit[i]);

	 _component->set_component (_component_load_store_unit [i]->_component
#ifdef POSITION
				    , 50, 50, 10, 10
#endif
				    );
       }

     _component_write_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Write_unit * [_param->_nb_write_unit];
     for (uint32_t i=0; i<_param->_nb_write_unit; i++)
       {
	 name = _name+"_write_unit_"+toString(i);
	 std::cout << "Create   : " << name << std::endl;

	 _component_write_unit [i] = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Write_unit
	   (name.c_str()
#ifdef STATISTICS
	    ,param_statistics
#endif
	    ,_param->_param_write_unit[i]);

	 _component->set_component (_component_write_unit [i]->_component
#ifdef POSITION
				    , 50, 50, 10, 10
#endif
				    );
       }
     
     {
       name = _name+"_read_unit_to_execution_unit";
       std::cout << "Create   : " << name << std::endl;
       
       _component_read_unit_to_execution_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Read_unit_to_Execution_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_read_unit_to_execution_unit);
       
       _component->set_component (_component_read_unit_to_execution_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_execution_unit_to_write_unit";
       std::cout << "Create   : " << name << std::endl;
       
       _component_execution_unit_to_write_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Execution_unit_to_Write_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_execution_unit_to_write_unit);
       
       _component->set_component (_component_execution_unit_to_write_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_register_unit";
       std::cout << "Create   : " << name << std::endl;
       
       _component_register_unit = new morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::Register_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_register_unit);
       
       _component->set_component (_component_register_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     std::string src,dest;

     // ===================================================================
     // =====[ READ_UNIT ]=================================================
     // ===================================================================
     {
       uint32_t it_read_unit_out = 0;
       
       for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	 {
	   src = _name+"_read_unit_"+toString(i);
	   std::cout << "Instance : " << src << std::endl;
	   
	   {
	     dest = _name;
#ifdef POSITION
	     _component->interface_map (src ,"",
					dest,"");
#endif
	     PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	     PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
	   }
	   
	   // ~~~~~[ Interface "read_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   {
	     dest = _name;
#ifdef POSITION
	     _component->interface_map (src ,"read_unit_in",
					dest,"execute_loop_in_"+toString(i));
#endif

	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_VAL"                  ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_VAL"                  );
	     PORT_MAP(_component ,src ,"out_READ_UNIT_IN_ACK"                  ,dest ,"out_EXECUTE_LOOP_IN_"+toString(i)+"_ACK"                  );
	     if (_param->_have_port_context_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_CONTEXT_ID"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_CONTEXT_ID"           );
	     if (_param->_have_port_front_end_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_FRONT_END_ID"         ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_FRONT_END_ID"         );
	     if (_param->_have_port_ooo_engine_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_OOO_ENGINE_ID"        ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_OOO_ENGINE_ID"        );
	     if (_param->_have_port_packet_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_PACKET_ID"            ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_PACKET_ID"            );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_OPERATION"            ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_OPERATION"            );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_TYPE"                 ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_TYPE"                 );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE",dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	     if (_param->_have_port_load_queue_ptr)
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE" ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_HAS_IMMEDIAT"         ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_HAS_IMMEDIAT"         );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_IMMEDIAT"             ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_IMMEDIAT"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_READ_RA"              ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_READ_RA"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_NUM_REG_RA"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_NUM_REG_RA"           );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_READ_RB"              ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_READ_RB"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_NUM_REG_RB"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_NUM_REG_RB"           );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_READ_RC"              ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_READ_RC"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_NUM_REG_RC"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_NUM_REG_RC"           );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_WRITE_RD"             ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_WRITE_RD"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_NUM_REG_RD"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_NUM_REG_RD"           );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_WRITE_RE"             ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_WRITE_RE"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_IN_NUM_REG_RE"           ,dest , "in_EXECUTE_LOOP_IN_"+toString(i)+"_NUM_REG_RE"           );
	   }

	   // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   for (uint32_t j=0; j < _param->_nb_inst_retire[i]; j++)
	     {
	       dest = _name+"_read_unit_to_execution_unit";
	       
#ifdef POSITION
	       _component->interface_map (src ,"read_unit_"+toString(i),
					  dest,"read_unit_"+toString(it_read_unit_out));
#endif
	     
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_VAL"                  ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_VAL"                  );
	       PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(i               )+"_ACK"                  ,
				    dest,"out_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_ACK"                  );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_CONTEXT_ID"           ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_CONTEXT_ID"           );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_FRONT_END_ID"         ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_FRONT_END_ID"         );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_OOO_ENGINE_ID"        ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_OOO_ENGINE_ID"        );
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_PACKET_ID"            ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_PACKET_ID"            );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_OPERATION"            ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_OPERATION"            );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_TYPE"                 ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_TYPE"                 );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_STORE_QUEUE_PTR_WRITE",
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_STORE_QUEUE_PTR_WRITE");
	       if (_param->_have_port_load_queue_ptr)
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_LOAD_QUEUE_PTR_WRITE" ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_LOAD_QUEUE_PTR_WRITE" );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_HAS_IMMEDIAT"         ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_HAS_IMMEDIAT"         );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_IMMEDIAT"             ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_IMMEDIAT"             );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_DATA_RA"              ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RA"              );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_DATA_RB"              ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RB"              );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_DATA_RC"              ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RC"              );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_WRITE_RD"             ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_WRITE_RD"             );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_NUM_REG_RD"           ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_NUM_REG_RD"           );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_WRITE_RE"             ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_WRITE_RE"             );
	       PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(i               )+"_NUM_REG_RE"           ,
				    dest, "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_NUM_REG_RE"           );
	     
	     it_read_unit_out ++;
	   }
	   
	   // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   {
	     dest = _name+"_register_unit";
#ifdef POSITION
	     _component->interface_map (src ,"gpr_read_0",
					dest,"gpr_read_"+toString(2*i  ));
	     _component->interface_map (src ,"gpr_read_1",
					dest,"gpr_read_"+toString(2*i+1));
#endif
	     PORT_MAP(_component ,src ,"out_GPR_READ_0_VAL"          , dest, "in_GPR_READ_"+toString(2*i  )+"_VAL"          );
	     PORT_MAP(_component ,src , "in_GPR_READ_0_ACK"          , dest,"out_GPR_READ_"+toString(2*i  )+"_ACK"          );
	     if (_param->_have_port_ooo_engine_id)
	     PORT_MAP(_component ,src ,"out_GPR_READ_0_OOO_ENGINE_ID", dest, "in_GPR_READ_"+toString(2*i  )+"_OOO_ENGINE_ID");
	     PORT_MAP(_component ,src ,"out_GPR_READ_0_NUM_REG"      , dest, "in_GPR_READ_"+toString(2*i  )+"_NUM_REG"      );
	     PORT_MAP(_component ,src , "in_GPR_READ_0_DATA"         , dest,"out_GPR_READ_"+toString(2*i  )+"_DATA"         );
	     PORT_MAP(_component ,src , "in_GPR_READ_0_DATA_VAL"     , dest,"out_GPR_READ_"+toString(2*i  )+"_DATA_VAL"     );
	     PORT_MAP(_component ,src ,"out_GPR_READ_1_VAL"          , dest, "in_GPR_READ_"+toString(2*i+1)+"_VAL"          );
	     PORT_MAP(_component ,src , "in_GPR_READ_1_ACK"          , dest,"out_GPR_READ_"+toString(2*i+1)+"_ACK"          );
	     if (_param->_have_port_ooo_engine_id)
	     PORT_MAP(_component ,src ,"out_GPR_READ_1_OOO_ENGINE_ID", dest, "in_GPR_READ_"+toString(2*i+1)+"_OOO_ENGINE_ID");
	     PORT_MAP(_component ,src ,"out_GPR_READ_1_NUM_REG"      , dest, "in_GPR_READ_"+toString(2*i+1)+"_NUM_REG"      );
	     PORT_MAP(_component ,src , "in_GPR_READ_1_DATA"         , dest,"out_GPR_READ_"+toString(2*i+1)+"_DATA"         );
	     PORT_MAP(_component ,src , "in_GPR_READ_1_DATA_VAL"     , dest,"out_GPR_READ_"+toString(2*i+1)+"_DATA_VAL"     );
	   }
	   
	   // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   {
	     dest = _name+"_register_unit";
#ifdef POSITION
	     _component->interface_map (src ,"spr_read_0",
					dest,"spr_read_"+toString(2*i  ));
#endif
	     PORT_MAP(_component ,src ,"out_SPR_READ_0_VAL"          , dest, "in_SPR_READ_"+toString(2*i  )+"_VAL"          );
	     PORT_MAP(_component ,src , "in_SPR_READ_0_ACK"          , dest,"out_SPR_READ_"+toString(2*i  )+"_ACK"          );
	     if (_param->_have_port_ooo_engine_id)
	     PORT_MAP(_component ,src ,"out_SPR_READ_0_OOO_ENGINE_ID", dest, "in_SPR_READ_"+toString(2*i  )+"_OOO_ENGINE_ID");
	     PORT_MAP(_component ,src ,"out_SPR_READ_0_NUM_REG"      , dest, "in_SPR_READ_"+toString(2*i  )+"_NUM_REG"      );
	     PORT_MAP(_component ,src , "in_SPR_READ_0_DATA"         , dest,"out_SPR_READ_"+toString(2*i  )+"_DATA"         );
	     PORT_MAP(_component ,src , "in_SPR_READ_0_DATA_VAL"     , dest,"out_SPR_READ_"+toString(2*i  )+"_DATA_VAL"     );
	   }
	   
	   // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   uint32_t it_gpr_write = 0;
	   for (std::set<uint32_t>::iterator it=_param->_set_read_unit_source_register_write[i].begin();
		it!=_param->_set_read_unit_source_register_write[i].end();
		it++)
	     {
	       dest = _name+"_write_unit_"+toString(*it);
#ifdef POSITION
	       _component->interface_map (src ,"gpr_write_"+toString(it_gpr_write),
					  dest,"gpr_write");
#endif
	       
	       PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_VAL"          ,
				    dest,"out_GPR_WRITE_0_VAL"          );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_OOO_ENGINE_ID",
				    dest,"out_GPR_WRITE_0_OOO_ENGINE_ID");
	       PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_NUM_REG"      ,
				    dest,"out_GPR_WRITE_0_NUM_REG"      );
	       PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_DATA"         ,
				    dest,"out_GPR_WRITE_0_DATA"         );

	       // PORT MAP to the "write_unit" component
#ifdef POSITION
	       _component->interface_map (dest,"gpr_write",
					  src ,"gpr_write_"+toString(it_gpr_write));
#endif
	       
	       PORT_MAP(_component ,dest,"out_GPR_WRITE_0_VAL"          ,
				    src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_VAL"          );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,dest,"out_GPR_WRITE_0_OOO_ENGINE_ID",
				    src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_OOO_ENGINE_ID");
	       PORT_MAP(_component ,dest,"out_GPR_WRITE_0_NUM_REG"      ,
				    src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_NUM_REG"      );
	       PORT_MAP(_component ,dest,"out_GPR_WRITE_0_DATA"         ,
				    src , "in_GPR_WRITE_"+toString(it_gpr_write)+"_DATA"         );
	       
	       it_gpr_write ++;
	     }
	   
	   // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   uint32_t it_spr_write = 0;
	   for (std::set<uint32_t>::iterator it=_param->_set_read_unit_source_register_write[i].begin();
		it!=_param->_set_read_unit_source_register_write[i].end();
		it++)
	     {
	       dest = _name+"_write_unit_"+toString(*it);
#ifdef POSITION
	       _component->interface_map (src ,"spr_write_"+toString(it_spr_write),
					  dest,"spr_write");
#endif
	       
	       PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(it_spr_write)+"_VAL"          ,
				    dest,"out_SPR_WRITE_0_VAL"          );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(it_spr_write)+"_OOO_ENGINE_ID",
				    dest,"out_SPR_WRITE_0_OOO_ENGINE_ID");
	       PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(it_spr_write)+"_NUM_REG"      ,
				    dest,"out_SPR_WRITE_0_NUM_REG"      );
	       PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(it_spr_write)+"_DATA"         ,
				    dest,"out_SPR_WRITE_0_DATA"         );

	       // PORT MAP to the "write_unit" component
#ifdef POSITION
	       _component->interface_map (dest,"spr_write",
					  src ,"spr_write_"+toString(it_spr_write));
#endif
	       PORT_MAP(_component ,dest,"out_SPR_WRITE_0_VAL"          ,
				    src , "in_SPR_WRITE_"+toString(it_spr_write)+"_VAL"          );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,dest,"out_SPR_WRITE_0_OOO_ENGINE_ID",
				    src , "in_SPR_WRITE_"+toString(it_spr_write)+"_OOO_ENGINE_ID");
	       PORT_MAP(_component ,dest,"out_SPR_WRITE_0_NUM_REG"      ,
				    src , "in_SPR_WRITE_"+toString(it_spr_write)+"_NUM_REG"      );
	       PORT_MAP(_component ,dest,"out_SPR_WRITE_0_DATA"         ,
				    src , "in_SPR_WRITE_"+toString(it_spr_write)+"_DATA"         );

	       it_spr_write ++;
	     }

	   // ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   uint32_t it_bypass_write = 0;
	   for (std::set<uint32_t>::iterator it=_param->_set_read_unit_source_bypass_write[i].begin();
		it!=_param->_set_read_unit_source_bypass_write[i].end();
		it++)
	     {
	       dest = _name+"_write_unit_"+toString(*it);

	       for (uint32_t j=0; j<_param->_nb_bypass_write[*it]; j++)
		 {
#ifdef POSITION
		   _component->interface_map (src ,"bypass_write_"+toString(it_bypass_write),
					      dest,"bypass_write_"+toString(j));
#endif
		   
		   if (_param->_have_port_ooo_engine_id)
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_OOO_ENGINE_ID",
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_OOO_ENGINE_ID");
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_VAL"      ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_VAL"      );
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_NUM_REG"  ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_NUM_REG"  );
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_DATA"     ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_DATA"     );
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_VAL"      ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_VAL"      );
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_NUM_REG"  ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_NUM_REG"  );
		   PORT_MAP(_component ,src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_DATA"     ,
					dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_DATA"     );

#ifdef POSITION
		   _component->interface_map (dest,"bypass_write_"+toString(j),
					      src ,"bypass_write_"+toString(it_bypass_write));
#endif
		   
		   if (_param->_have_port_ooo_engine_id)
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_OOO_ENGINE_ID",
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_OOO_ENGINE_ID");
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_VAL"      ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_VAL"      );
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_NUM_REG"  ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_NUM_REG"  );
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_GPR_DATA"     ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_GPR_DATA"     );
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_VAL"      ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_VAL"      );
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_NUM_REG"  ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_NUM_REG"  );
		   PORT_MAP(_component ,dest,"out_BYPASS_WRITE_"+toString(j              )+"_SPR_DATA"     ,
					src , "in_BYPASS_WRITE_"+toString(it_bypass_write)+"_SPR_DATA"     );

		   it_bypass_write ++;
		 }
	     }

	   // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	   uint32_t it_bypass_memory = 0;
	   for (std::set<uint32_t>::iterator it=_param->_set_read_unit_source_bypass_memory[i].begin();
		it!=_param->_set_read_unit_source_bypass_memory[i].end();
		it++)
	     {
	       dest = _name+"_load_store_unit_"+toString(_param->_translate_num_execute_unit[*it]);

	       for (uint32_t j=0; j<_param->_nb_bypass_memory[_param->_translate_num_execute_unit[*it]]; j++)
		 {
#ifdef POSITION
		   _component->interface_map (src ,"bypass_memory_"+toString(it_bypass_memory),
					      dest,"bypass_memory_"+toString(j));
#endif
		   
		   if (_param->_have_port_ooo_engine_id)
		   PORT_MAP(_component ,src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_OOO_ENGINE_ID",
					dest,"out_BYPASS_MEMORY_"+toString(j               )+"_OOO_ENGINE_ID");
		   PORT_MAP(_component ,src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_VAL"          ,
					dest,"out_BYPASS_MEMORY_"+toString(j               )+"_VAL"          );
		   PORT_MAP(_component ,src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_NUM_REG"      ,
					dest,"out_BYPASS_MEMORY_"+toString(j               )+"_NUM_REG"      );
		   PORT_MAP(_component ,src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_DATA"         ,
					dest,"out_BYPASS_MEMORY_"+toString(j               )+"_DATA"         );

		   // port map to the "load_store_unit" component
#ifdef POSITION
		   _component->interface_map (dest,"bypass_memory_"+toString(j),
					      src ,"bypass_memory_"+toString(it_bypass_memory));
#endif
		   
		   if (_param->_have_port_ooo_engine_id)
		   PORT_MAP(_component ,dest,"out_BYPASS_MEMORY_"+toString(j               )+"_OOO_ENGINE_ID",
					src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_OOO_ENGINE_ID");
		   PORT_MAP(_component ,dest,"out_BYPASS_MEMORY_"+toString(j               )+"_VAL"          ,
					src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_VAL"          );
		   PORT_MAP(_component ,dest,"out_BYPASS_MEMORY_"+toString(j               )+"_NUM_REG"      ,
					src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_NUM_REG"      );
		   PORT_MAP(_component ,dest,"out_BYPASS_MEMORY_"+toString(j               )+"_DATA"         ,
					src , "in_BYPASS_MEMORY_"+toString(it_bypass_memory)+"_DATA"         );

		   it_bypass_memory ++;
		 }
	     }
	 }
     }

     // ===================================================================
     // =====[ EXECUTE_UNIT ]==============================================    
     // ===================================================================
     for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
       {
	 uint32_t x=_param->_translate_num_execute_unit[i];
	 
	 if (_param->_is_load_store_unit[i] == false)
	   {
	     // ===================================================================
	     // =====[ FUNCTIONNAL_UNIT ]==========================================    
	     // ===================================================================

	     src = _name+"_functionnal_unit_"+toString(x);
	     std::cout << "Instance : " << src << std::endl;
	     
	     {
	       dest = _name;
#ifdef POSITION
	       _component->interface_map (src ,"",
					  dest,"");
#endif
	       PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	       PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
	     }
    
	     // ~~~~~[ Interface "execute_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name+"_read_unit_to_execution_unit";

#ifdef POSITION
	       _component->interface_map (src ,"execute_in",
					  dest,"execute_unit_in_"+toString(i));
#endif

	       PORT_MAP(_component ,src , "in_EXECUTE_IN_VAL"                  ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_VAL"                  );
	       PORT_MAP(_component ,src ,"out_EXECUTE_IN_ACK"                  ,
				    dest, "in_EXECUTE_UNIT_IN_"+toString(i)+"_ACK"                  );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_CONTEXT_ID"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"           );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_FRONT_END_ID"         ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_FRONT_END_ID"         );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_OOO_ENGINE_ID"        ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID"        );
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_PACKET_ID"            ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_PACKET_ID"            );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_OPERATION"            ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OPERATION"            );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_TYPE"                 ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_TYPE"                 );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE",
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	       if (_param->_have_port_load_queue_ptr)
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE" ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_HAS_IMMEDIAT"         ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_HAS_IMMEDIAT"         );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_IMMEDIAT"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_IMMEDIAT"             );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_DATA_RA"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RA"              );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_DATA_RB"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RB"              );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_DATA_RC"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RC"              );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_WRITE_RD"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RD"             );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_NUM_REG_RD"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"           );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_WRITE_RE"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RE"             );
	       PORT_MAP(_component ,src , "in_EXECUTE_IN_NUM_REG_RE"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"           );
	     }
	     
	     // ~~~~~[ Interface "execute_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name+"_execution_unit_to_write_unit";
	       
#ifdef POSITION
	       _component->interface_map (src ,"execute_out",
					  dest,"execute_unit_out_"+toString(i));
#endif

  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_VAL"          ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_VAL"          );
  	       PORT_MAP(_component ,src , "in_EXECUTE_OUT_ACK"          ,
				    dest,"out_EXECUTE_UNIT_OUT_"+toString(i)+"_ACK"          );
	       if (_param->_have_port_context_id)
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_CONTEXT_ID"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_CONTEXT_ID"   );
	       if (_param->_have_port_front_end_id)
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_FRONT_END_ID" ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_FRONT_END_ID" );
	       if (_param->_have_port_ooo_engine_id)
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_OOO_ENGINE_ID",
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OOO_ENGINE_ID");
	       if (_param->_have_port_packet_id)
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_PACKET_ID"    ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_PACKET_ID"    );
//	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_OPERATION"    ,
// 				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OPERATION"    );
	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_TYPE"         ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_TYPE"         );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_WRITE_RD"     ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RD"     );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_NUM_REG_RD"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RD"   );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_DATA_RD"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RD"      );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_WRITE_RE"     ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RE"     );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_NUM_REG_RE"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RE"   );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_DATA_RE"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RE"      );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_EXCEPTION"    ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_EXCEPTION"    );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_NO_SEQUENCE"  ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NO_SEQUENCE"  );
  	       PORT_MAP(_component ,src ,"out_EXECUTE_OUT_ADDRESS"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_ADDRESS"      );
	     }
	   }
	 else
	   {
	     // ===================================================================
	     // =====[ LOAD_STORE_UNIT ]===========================================    
	     // ===================================================================
  
	     src = _name+"_load_store_unit_"+toString(x);
	     std::cout << "Instance : " << src << std::endl;

	     // ~~~~~[ Interface "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name;
#ifdef POSITION
	       _component->interface_map (src ,"",
					  dest,"");
#endif
	       PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	       PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
	     }
	 
	     // ~~~~~[ Interface "memory_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name+"_read_unit_to_execution_unit";

#ifdef POSITION
	       _component->interface_map (src ,"memory_in",
					  dest,"execute_unit_in_"+toString(i));
#endif

	       PORT_MAP(_component ,src , "in_MEMORY_IN_VAL"                  ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_VAL"                  );
	       PORT_MAP(_component ,src ,"out_MEMORY_IN_ACK"                  ,
				    dest, "in_EXECUTE_UNIT_IN_"+toString(i)+"_ACK"                  );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src , "in_MEMORY_IN_CONTEXT_ID"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"           );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src , "in_MEMORY_IN_FRONT_END_ID"         ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_FRONT_END_ID"         );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_MEMORY_IN_OOO_ENGINE_ID"        ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID"        );
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src , "in_MEMORY_IN_PACKET_ID"            ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_PACKET_ID"            );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_OPERATION"            ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OPERATION"            );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_TYPE"                 ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_TYPE"                 );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_STORE_QUEUE_PTR_WRITE",
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	       if (_param->_have_port_load_queue_ptr)
	       PORT_MAP(_component ,src , "in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE" ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_HAS_IMMEDIAT"         ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_HAS_IMMEDIAT"         );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_IMMEDIAT"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_IMMEDIAT"             );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_DATA_RA"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RA"              );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_DATA_RB"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RB"              );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_DATA_RC"              ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RC"              );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_WRITE_RD"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RD"             );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_NUM_REG_RD"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"           );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_WRITE_RE"             ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RE"             );
	       PORT_MAP(_component ,src , "in_MEMORY_IN_NUM_REG_RE"           ,
				    dest,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"           );
	     }

	     // ~~~~~[ Interface "memory_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name+"_execution_unit_to_write_unit";
	       
#ifdef POSITION
	       _component->interface_map (src ,"memory_out",
					  dest,"execute_unit_out_"+toString(i));
#endif

  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_VAL"          ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_VAL"          );
  	       PORT_MAP(_component ,src , "in_MEMORY_OUT_ACK"          ,
				    dest,"out_EXECUTE_UNIT_OUT_"+toString(i)+"_ACK"          );
	       if (_param->_have_port_context_id)
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_CONTEXT_ID"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_CONTEXT_ID"   );
	       if (_param->_have_port_front_end_id)
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_FRONT_END_ID" ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_FRONT_END_ID" );
	       if (_param->_have_port_ooo_engine_id)
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_OOO_ENGINE_ID",
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OOO_ENGINE_ID");
	       if (_param->_have_port_packet_id)
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_PACKET_ID"    ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_PACKET_ID"    );
//	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_OPERATION"    ,
// 				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OPERATION"    );
	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_TYPE"         ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_TYPE"         );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_WRITE_RD"     ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RD"     );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_NUM_REG_RD"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RD"   );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_DATA_RD"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RD"      );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_WRITE_RE"     ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RE"     );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_NUM_REG_RE"   ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RE"   );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_DATA_RE"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RE"      );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_EXCEPTION"    ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_EXCEPTION"    );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_NO_SEQUENCE"  ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NO_SEQUENCE"  );
  	       PORT_MAP(_component ,src ,"out_MEMORY_OUT_ADDRESS"      ,
				    dest, "in_EXECUTE_UNIT_OUT_"+toString(i)+"_ADDRESS"      );
	     }

	     // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name;
	       
#ifdef POSITION
	       _component->interface_map (src ,"dcache_req",
					  dest,"dcache_req_"+toString(i));
#endif
  	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_VAL"       ,dest,"out_DCACHE_REQ_"+toString(i)+"_VAL"       );
  	       PORT_MAP(_component ,src , "in_DCACHE_REQ_ACK"       ,dest, "in_DCACHE_REQ_"+toString(i)+"_ACK"       );
  	       if (_param->_have_port_dcache_context_id)
	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_CONTEXT_ID",dest,"out_DCACHE_REQ_"+toString(i)+"_CONTEXT_ID");
  	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_PACKET_ID" ,dest,"out_DCACHE_REQ_"+toString(i)+"_PACKET_ID" );
  	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_ADDRESS"   ,dest,"out_DCACHE_REQ_"+toString(i)+"_ADDRESS"   );
  	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_TYPE"      ,dest,"out_DCACHE_REQ_"+toString(i)+"_TYPE"      );
  	       PORT_MAP(_component ,src ,"out_DCACHE_REQ_WDATA"     ,dest,"out_DCACHE_REQ_"+toString(i)+"_WDATA"     );
	     }

	     // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       dest = _name;
	       
#ifdef POSITION
	       _component->interface_map (src ,"dcache_rsp",
					  dest,"dcache_rsp_"+toString(i));
#endif
  	       PORT_MAP(_component ,src , "in_DCACHE_RSP_VAL"       ,dest, "in_DCACHE_RSP_"+toString(i)+"_VAL"       );
  	       PORT_MAP(_component ,src ,"out_DCACHE_RSP_ACK"       ,dest,"out_DCACHE_RSP_"+toString(i)+"_ACK"       );
  	       if (_param->_have_port_dcache_context_id)
  	       PORT_MAP(_component ,src , "in_DCACHE_RSP_CONTEXT_ID",dest, "in_DCACHE_RSP_"+toString(i)+"_CONTEXT_ID");
  	       PORT_MAP(_component ,src , "in_DCACHE_RSP_PACKET_ID" ,dest, "in_DCACHE_RSP_"+toString(i)+"_PACKET_ID" );
  	       PORT_MAP(_component ,src , "in_DCACHE_RSP_RDATA"     ,dest, "in_DCACHE_RSP_"+toString(i)+"_RDATA"     );
  	       PORT_MAP(_component ,src , "in_DCACHE_RSP_ERROR"     ,dest, "in_DCACHE_RSP_"+toString(i)+"_ERROR"     );
	     }

	     // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	     {
	       // Port map with "read_unit" is ok!
	     }
	   }
       }

     // ===================================================================
     // =====[ WRITE_UNIT ]================================================
     // ===================================================================
     for (uint32_t i=0; i<_param->_nb_write_unit; i++)
       {
	 src = _name+"_write_unit_"+toString(i);
	 std::cout << "Instance : " << src << std::endl;
	 
	 {
	   dest = _name;
#ifdef POSITION
	   _component->interface_map (src ,"",
				      dest,"");
#endif
	   PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	   PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
	 }

	 // -----[ Interface "write_unit_in" ]---------------------------------    
	 {
	   dest = _name+"_execution_unit_to_write_unit";
#ifdef POSITION
	   _component->interface_map (src ,"write_unit_in",
				      dest,"execute_unit_in_"+toString(i));
#endif
	   
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_VAL"          ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_VAL"          );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_ACK"          ,
				dest, "in_WRITE_UNIT_IN_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_context_id)
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_CONTEXT_ID"   ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_FRONT_END_ID" ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_OOO_ENGINE_ID",
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_PACKET_ID"    ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_PACKET_ID"    );
// 	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_OPERATION"    ,
// 				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_OPERATION"    );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_TYPE"         ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_TYPE"         );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_WRITE_RD"     ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_WRITE_RD"     );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_NUM_REG_RD"   ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"   );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_DATA_RD"      ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_DATA_RD"      );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_WRITE_RE"     ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_WRITE_RE"     );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_NUM_REG_RE"   ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"   );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_DATA_RE"      ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_DATA_RE"      );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_EXCEPTION"    ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_EXCEPTION"    );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_NO_SEQUENCE"  ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_NO_SEQUENCE"  );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_ADDRESS"      ,
				dest,"out_WRITE_UNIT_IN_"+toString(i)+"_ADDRESS"      );
	 }

	 // -----[ Interface "write_unit_out" ]--------------------------------    
	 {
	   dest = _name;
#ifdef POSITION
	   _component->interface_map (src ,"write_unit_out",
				      dest,"execute_loop_out_"+toString(i));
#endif
	   
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_VAL"          ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_VAL"          );
  	   PORT_MAP(_component ,src , "in_WRITE_UNIT_OUT_ACK"          ,
				dest, "in_EXECUTE_LOOP_OUT_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_context_id)
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_CONTEXT_ID"   ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_FRONT_END_ID" ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_OOO_ENGINE_ID",
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_PACKET_ID"    ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_PACKET_ID"    );
//	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_OPERATION"    ,
// 				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_OPERATION"    );
//	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_TYPE"         ,
// 				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_TYPE"         );
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_FLAGS"        ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_FLAGS"        );
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_EXCEPTION"    ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_EXCEPTION"    );
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_NO_SEQUENCE"  ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_NO_SEQUENCE"  );
  	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_OUT_ADDRESS"      ,
				dest,"out_EXECUTE_LOOP_OUT_"+toString(i)+"_ADDRESS"      );
	 }
	 // -----[ Interface "gpr_write" ]-------------------------------------
	 {
	   // Port map with "read_unit" is ok!

	   dest = _name+"_register_unit";
#ifdef POSITION
	   _component->interface_map (src ,"gpr_write",
				      dest,"gpr_write_"+toString(i));
#endif

  	   PORT_MAP(_component ,src ,"out_GPR_WRITE_0_VAL"          ,
				dest, "in_GPR_WRITE_"+toString(i)+"_VAL"          );
  	   PORT_MAP(_component ,src , "in_GPR_WRITE_0_ACK"          ,
				dest,"out_GPR_WRITE_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_context_id)
  	   PORT_MAP(_component ,src ,"out_GPR_WRITE_0_OOO_ENGINE_ID",
				dest, "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
  	   PORT_MAP(_component ,src ,"out_GPR_WRITE_0_NUM_REG"      ,
				dest, "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      );
  	   PORT_MAP(_component ,src ,"out_GPR_WRITE_0_DATA"         ,
				dest, "in_GPR_WRITE_"+toString(i)+"_DATA"         );
	 }

	 // -----[ Interface "spr_write" ]-------------------------------------
	 {
	   // Port map with "read_unit" is ok!

	   dest = _name+"_register_unit";
#ifdef POSITION
	   _component->interface_map (src ,"spr_write",
				      dest,"spr_write_"+toString(i));
#endif

  	   PORT_MAP(_component ,src ,"out_SPR_WRITE_0_VAL"          ,
				dest, "in_SPR_WRITE_"+toString(i)+"_VAL"          );
  	   PORT_MAP(_component ,src , "in_SPR_WRITE_0_ACK"          ,
				dest,"out_SPR_WRITE_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_context_id)
  	   PORT_MAP(_component ,src ,"out_SPR_WRITE_0_OOO_ENGINE_ID",
				dest, "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
  	   PORT_MAP(_component ,src ,"out_SPR_WRITE_0_NUM_REG"      ,
				dest, "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      );
  	   PORT_MAP(_component ,src ,"out_SPR_WRITE_0_DATA"         ,
				dest, "in_SPR_WRITE_"+toString(i)+"_DATA"         );
	 }

	 // -----[ Interface "bypass_write" ]----------------------------------
	 {
	   // Port map with "read_unit" is ok!
	 }
       }

     // ===================================================================
     // =====[ REGISTER_UNIT ]=============================================
     // ===================================================================
     {
       src = _name+"_register_unit";
       std::cout << "Instance : " << src << std::endl;
       
       {
	 dest = _name;
#ifdef POSITION
	 _component->interface_map (src ,"",
				    dest,"");
#endif
	 PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	 PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
       }

       // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	 {
	   dest = _name+"_read_unit_"+toString(i);
#ifdef POSITION
	   _component->interface_map (src ,"gpr_read_"+toString(2*i  )
				      dest,"gpr_read_0");
	   _component->interface_map (src ,"gpr_read_"+toString(2*i+1)
				      dest,"gpr_read_1");
#endif
       
	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i  )+"_VAL"          ,dest,"out_GPR_READ_0_VAL"          );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i  )+"_ACK"          ,dest, "in_GPR_READ_0_ACK"          );
	 if (_param->_have_port_context_id)
	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i  )+"_OOO_ENGINE_ID",dest,"out_GPR_READ_0_OOO_ENGINE_ID");
	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i  )+"_NUM_REG"      ,dest,"out_GPR_READ_0_NUM_REG"      );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i  )+"_DATA"         ,dest, "in_GPR_READ_0_DATA"         );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i  )+"_DATA_VAL"     ,dest, "in_GPR_READ_0_DATA_VAL"     );

	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i+1)+"_VAL"          ,dest,"out_GPR_READ_1_VAL"          );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i+1)+"_ACK"          ,dest, "in_GPR_READ_1_ACK"          );
	 if (_param->_have_port_context_id)
	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i+1)+"_OOO_ENGINE_ID",dest,"out_GPR_READ_1_OOO_ENGINE_ID");
	 PORT_MAP(_component ,src , "in_GPR_READ_"+toString(2*i+1)+"_NUM_REG"      ,dest,"out_GPR_READ_1_NUM_REG"      );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i+1)+"_DATA"         ,dest, "in_GPR_READ_1_DATA"         );
	 PORT_MAP(_component ,src ,"out_GPR_READ_"+toString(2*i+1)+"_DATA_VAL"     ,dest, "in_GPR_READ_1_DATA_VAL"     );
	 }

       // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	 {
	   dest = _name+"_write_unit_"+toString(i);
#ifdef POSITION
	   _component->interface_map (src ,"gpr_write_"+toString(i)
				      dest,"gpr_write_0");
#endif
       
	   PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(i)+"_VAL"          ,dest,"out_GPR_WRITE_0_VAL"          );
	   PORT_MAP(_component ,src ,"out_GPR_WRITE_"+toString(i)+"_ACK"          ,dest, "in_GPR_WRITE_0_ACK"          );
	   if (_param->_have_port_context_id)
	   PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest,"out_GPR_WRITE_0_OOO_ENGINE_ID");
	   PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest,"out_GPR_WRITE_0_NUM_REG"      );
	   PORT_MAP(_component ,src , "in_GPR_WRITE_"+toString(i)+"_DATA"         ,dest,"out_GPR_WRITE_0_DATA"         );
	 }

       // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	 {
	   dest = _name+"_read_unit_"+toString(i);
#ifdef POSITION
	   _component->interface_map (src ,"spr_read_"+toString(i),
				      dest,"spr_read_0");
#endif
       
	   PORT_MAP(_component ,src , "in_SPR_READ_"+toString(i)+"_VAL"          ,dest,"out_SPR_READ_0_VAL"          );
	   PORT_MAP(_component ,src ,"out_SPR_READ_"+toString(i)+"_ACK"          ,dest, "in_SPR_READ_0_ACK"          );
	   if (_param->_have_port_context_id)
	   PORT_MAP(_component ,src , "in_SPR_READ_"+toString(i)+"_OOO_ENGINE_ID",dest,"out_SPR_READ_0_OOO_ENGINE_ID");
	   PORT_MAP(_component ,src , "in_SPR_READ_"+toString(i)+"_NUM_REG"      ,dest,"out_SPR_READ_0_NUM_REG"      );
	   PORT_MAP(_component ,src ,"out_SPR_READ_"+toString(i)+"_DATA"         ,dest, "in_SPR_READ_0_DATA"         );
	   PORT_MAP(_component ,src ,"out_SPR_READ_"+toString(i)+"_DATA_VAL"     ,dest, "in_SPR_READ_0_DATA_VAL"     );
	 }

       // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	 {
	   dest = _name+"_write_unit_"+toString(i);
#ifdef POSITION
	   _component->interface_map (src ,"spr_write_"+toString(i)
				      dest,"spr_write_0");
#endif
       
	   PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(i)+"_VAL"          ,dest,"out_SPR_WRITE_0_VAL"          );
	   PORT_MAP(_component ,src ,"out_SPR_WRITE_"+toString(i)+"_ACK"          ,dest, "in_SPR_WRITE_0_ACK"          );
	   if (_param->_have_port_context_id)
	   PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest,"out_SPR_WRITE_0_OOO_ENGINE_ID");
	   PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest,"out_SPR_WRITE_0_NUM_REG"      );
	   PORT_MAP(_component ,src , "in_SPR_WRITE_"+toString(i)+"_DATA"         ,dest,"out_SPR_WRITE_0_DATA"         );
	 }
    
       // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   uint32_t x=_param->_nb_inst_insert_rob [i];
	   
	   for (uint32_t j=0; j<x; j++)
	     {
	       dest = _name;
#ifdef POSITION
	       _component->interface_map (src ,"insert_rob_"+toString(i)+"_"+toString(j),
					  dest,"insert_rob_"+toString(i)+"_"+toString(j));
#endif

	       PORT_MAP(_component ,src , "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_VAL"       ,
				    dest, "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_VAL"       );
	       PORT_MAP(_component ,src ,"out_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_ACK"       ,
				    dest,"out_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_ACK"       );
	       PORT_MAP(_component ,src , "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_USE"    ,
				    dest, "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_USE"    );
	       PORT_MAP(_component ,src , "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_NUM_REG",
				    dest, "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RD_NUM_REG");
	       PORT_MAP(_component ,src , "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_USE"    ,
				    dest, "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_USE"    );
	       PORT_MAP(_component ,src , "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_NUM_REG",
				    dest, "in_INSERT_ROB_"+toString(i)+"_"+toString(j)+"_RE_NUM_REG");
	     }
	 }

       // ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	 {
	   uint32_t x=_param->_nb_inst_retire_rob [i];
	   
	   for (uint32_t j=0; j<x; j++)
	     {
	       dest = _name;
#ifdef POSITION
	       _component->interface_map (src ,"retire_rob_"+toString(i)+"_"+toString(j),
					  dest,"retire_rob_"+toString(i)+"_"+toString(j));
#endif

	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_VAL"           ,
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_VAL"           );
	       PORT_MAP(_component ,src ,"out_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_ACK"           ,
				    dest,"out_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_ACK"           );
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_USE"    ,
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_USE"    );
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_NUM_REG",
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_OLD_NUM_REG");
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_USE"    ,
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_USE"    );
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_NUM_REG",
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RD_NEW_NUM_REG");
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_USE"    ,
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_USE"    );
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_NUM_REG",
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_OLD_NUM_REG");
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_USE"    ,
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_USE"    );
	       PORT_MAP(_component ,src , "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_NUM_REG",
				    dest, "in_RETIRE_ROB_"+toString(i)+"_"+toString(j)+"_RE_NEW_NUM_REG");
	     }
	 }
     }

     // ===================================================================
     // =====[ READ_UNIT_TO_EXECUTION_UNIT ]===============================
     // ===================================================================
     {
       src = _name+"_read_unit_to_execution_unit";
       std::cout << "Instance : " << src << std::endl;
       
       {
	 dest = _name;
#ifdef POSITION
	 _component->interface_map (src ,"",
				    dest,"");
#endif
	 PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	 PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
       }

       // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       uint32_t it_read_unit_out =0;
       for (uint32_t i=0; i < _param->_nb_read_unit; i++)
	 for (uint32_t j=0; j < _param->_nb_inst_retire[i]; j++)
	   {
	     dest = _name+"_read_unit_"+toString(i);
	     
#ifdef POSITION
	     _component->interface_map (src ,"read_unit_"+toString(it_read_unit_out),
					dest,"read_unit_"+toString(j));
#endif
	     
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_VAL"                  ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_VAL"                  );
	     PORT_MAP(_component ,src ,"out_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_ACK"                  ,
				  dest, "in_READ_UNIT_OUT_"+toString(j               )+"_ACK"                  );
	     if (_param->_have_port_context_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_CONTEXT_ID"           ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_CONTEXT_ID"           );
	     if (_param->_have_port_front_end_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_FRONT_END_ID"         ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_FRONT_END_ID"         );
	     if (_param->_have_port_ooo_engine_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_OOO_ENGINE_ID"        ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_OOO_ENGINE_ID"        );
	     if (_param->_have_port_packet_id)
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_PACKET_ID"            ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_PACKET_ID"            );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_OPERATION"            ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_OPERATION"            );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_TYPE"                 ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_TYPE"                 );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_STORE_QUEUE_PTR_WRITE",
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_STORE_QUEUE_PTR_WRITE");
	     if (_param->_have_port_load_queue_ptr)
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_LOAD_QUEUE_PTR_WRITE" ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_LOAD_QUEUE_PTR_WRITE" );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_HAS_IMMEDIAT"         ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_HAS_IMMEDIAT"         );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_IMMEDIAT"             ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_IMMEDIAT"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RA"              ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_DATA_RA"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RB"              ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_DATA_RB"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_DATA_RC"              ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_DATA_RC"              );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_WRITE_RD"             ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_WRITE_RD"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_NUM_REG_RD"           ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_NUM_REG_RD"           );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_WRITE_RE"             ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_WRITE_RE"             );
	     PORT_MAP(_component ,src , "in_READ_UNIT_OUT_"+toString(it_read_unit_out)+"_NUM_REG_RE"           ,
				  dest,"out_READ_UNIT_OUT_"+toString(j               )+"_NUM_REG_RE"           );
	     
	     it_read_unit_out ++;
	   }
       
       // ~~~~~[ Interface "execute_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	 {
	   uint32_t x=_param->_translate_num_execute_unit[i];
	   
	   if (_param->_is_load_store_unit[i] == false)
	     {
	       dest = _name+"_functionnal_unit_"+toString(x);
	       
#ifdef POSITION
	       _component->interface_map (src ,"execute_unit_in_"+toString(i),
					  dest,"execute_in");
#endif
	       
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_VAL"                  ,
				    dest, "in_EXECUTE_IN_VAL"                  );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_IN_"+toString(i)+"_ACK"                  ,
				    dest,"out_EXECUTE_IN_ACK"                  );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"           ,
				    dest, "in_EXECUTE_IN_CONTEXT_ID"           );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_FRONT_END_ID"         ,
				    dest, "in_EXECUTE_IN_FRONT_END_ID"         );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID"        ,
				    dest, "in_EXECUTE_IN_OOO_ENGINE_ID"        );
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_PACKET_ID"            ,
				    dest, "in_EXECUTE_IN_PACKET_ID"            );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OPERATION"            ,
				    dest, "in_EXECUTE_IN_OPERATION"            );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_TYPE"                 ,
				    dest, "in_EXECUTE_IN_TYPE"                 );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
				    dest, "in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE");
	       if (_param->_have_port_load_queue_ptr)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
				    dest, "in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE" );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_HAS_IMMEDIAT"         ,
				    dest, "in_EXECUTE_IN_HAS_IMMEDIAT"         );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_IMMEDIAT"             ,
				    dest, "in_EXECUTE_IN_IMMEDIAT"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RA"              ,
				    dest, "in_EXECUTE_IN_DATA_RA"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RB"              ,
				    dest, "in_EXECUTE_IN_DATA_RB"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RC"              ,
				    dest, "in_EXECUTE_IN_DATA_RC"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RD"             ,
				    dest, "in_EXECUTE_IN_WRITE_RD"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"           ,
				    dest, "in_EXECUTE_IN_NUM_REG_RD"           );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RE"             ,
				    dest, "in_EXECUTE_IN_WRITE_RE"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"           ,
				    dest, "in_EXECUTE_IN_NUM_REG_RE"           );
 	     }
	   else
	     {
	       dest = _name+"_load_store_unit_"+toString(x);
	       
#ifdef POSITION
	       _component->interface_map (src ,"execute_unit_in_"+toString(i),
					  dest,"memory_in");
#endif
	       
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_VAL"                  ,
				    dest, "in_MEMORY_IN_VAL"                  );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_IN_"+toString(i)+"_ACK"                  ,
				    dest,"out_MEMORY_IN_ACK"                  );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"           ,
				    dest, "in_MEMORY_IN_CONTEXT_ID"           );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_FRONT_END_ID"         ,
				    dest, "in_MEMORY_IN_FRONT_END_ID"         );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID"        ,
				    dest, "in_MEMORY_IN_OOO_ENGINE_ID"        );
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_PACKET_ID"            ,
				    dest, "in_MEMORY_IN_PACKET_ID"            );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_OPERATION"            ,
				    dest, "in_MEMORY_IN_OPERATION"            );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_TYPE"                 ,
				    dest, "in_MEMORY_IN_TYPE"                 );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
				    dest, "in_MEMORY_IN_STORE_QUEUE_PTR_WRITE");
	       if (_param->_have_port_load_queue_ptr)
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
				    dest, "in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE" );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_HAS_IMMEDIAT"         ,
				    dest, "in_MEMORY_IN_HAS_IMMEDIAT"         );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_IMMEDIAT"             ,
				    dest, "in_MEMORY_IN_IMMEDIAT"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RA"              ,
				    dest, "in_MEMORY_IN_DATA_RA"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RB"              ,
				    dest, "in_MEMORY_IN_DATA_RB"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_DATA_RC"              ,
				    dest, "in_MEMORY_IN_DATA_RC"              );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RD"             ,
				    dest, "in_MEMORY_IN_WRITE_RD"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"           ,
				    dest, "in_MEMORY_IN_NUM_REG_RD"           );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_WRITE_RE"             ,
				    dest, "in_MEMORY_IN_WRITE_RE"             );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"           ,
				    dest, "in_MEMORY_IN_NUM_REG_RE"           );
 	     }
	 }
     }
     
     // ===================================================================
     // =====[ EXECUTION_UNIT_TO_WRITE_UNIT ]==============================
     // ===================================================================
     {
       src = _name+"_execution_unit_to_write_unit";
       std::cout << "Instance : " << src << std::endl;

       {
	 dest = _name;
#ifdef POSITION
	 _component->interface_map (src ,"",
				    dest,"");
#endif
	 PORT_MAP(_component ,src , "in_CLOCK" ,dest, "in_CLOCK");
	 PORT_MAP(_component ,src , "in_NRESET",dest, "in_NRESET");
       }

       // ~~~~~[ Interface "execute_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	 {
	   uint32_t x=_param->_translate_num_execute_unit[i];
	   
	   if (_param->_is_load_store_unit[i] == false)
	     {
	       dest = _name+"_functionnal_unit_"+toString(x);
	       
#ifdef POSITION
	       _component->interface_map (src ,"execute_unit_out_"+toString(i),
					  dest,"execute_out");
#endif
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_VAL"          ,
				    dest,"out_EXECUTE_OUT_VAL"          );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_OUT_"+toString(i)+"_ACK"          ,
				    dest, "in_EXECUTE_OUT_ACK"          );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_CONTEXT_ID"   ,
				    dest,"out_EXECUTE_OUT_CONTEXT_ID"   );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_FRONT_END_ID" ,
				    dest,"out_EXECUTE_OUT_FRONT_END_ID" );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OOO_ENGINE_ID",
				    dest,"out_EXECUTE_OUT_OOO_ENGINE_ID");
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_PACKET_ID"    ,
				    dest,"out_EXECUTE_OUT_PACKET_ID"    );
// 	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OPERATION"    ,
// 				    dest,"out_EXECUTE_OUT_OPERATION"    );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_TYPE"         ,
				    dest,"out_EXECUTE_OUT_TYPE"         );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RD"     ,
				    dest,"out_EXECUTE_OUT_WRITE_RD"     );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RD"   ,
				    dest,"out_EXECUTE_OUT_NUM_REG_RD"   );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RD"      ,
				    dest,"out_EXECUTE_OUT_DATA_RD"      );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RE"     ,
				    dest,"out_EXECUTE_OUT_WRITE_RE"     );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RE"   ,
				    dest,"out_EXECUTE_OUT_NUM_REG_RE"   );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RE"      ,
				    dest,"out_EXECUTE_OUT_DATA_RE"      );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_EXCEPTION"    ,
				    dest,"out_EXECUTE_OUT_EXCEPTION"    );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NO_SEQUENCE"  ,
				    dest,"out_EXECUTE_OUT_NO_SEQUENCE"  );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_ADDRESS"      ,
				    dest,"out_EXECUTE_OUT_ADDRESS"      );
	     }
	   else
	     {
	       dest = _name+"_load_store_unit_"+toString(x);
	       
#ifdef POSITION
	       _component->interface_map (src ,"execute_unit_out_"+toString(i),
					  dest,"memory_out");
#endif
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_VAL"          ,
				    dest,"out_MEMORY_OUT_VAL"          );
	       PORT_MAP(_component ,src ,"out_EXECUTE_UNIT_OUT_"+toString(i)+"_ACK"          ,
				    dest, "in_MEMORY_OUT_ACK"          );
	       if (_param->_have_port_context_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_CONTEXT_ID"   ,
				    dest,"out_MEMORY_OUT_CONTEXT_ID"   );
	       if (_param->_have_port_front_end_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_FRONT_END_ID" ,
				    dest,"out_MEMORY_OUT_FRONT_END_ID" );
	       if (_param->_have_port_ooo_engine_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OOO_ENGINE_ID",
				    dest,"out_MEMORY_OUT_OOO_ENGINE_ID");
	       if (_param->_have_port_packet_id)
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_PACKET_ID"    ,
				    dest,"out_MEMORY_OUT_PACKET_ID"    );
// 	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_OPERATION"    ,
// 				    dest,"out_MEMORY_OUT_OPERATION"    );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_TYPE"         ,
				    dest,"out_MEMORY_OUT_TYPE"         );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RD"     ,
				    dest,"out_MEMORY_OUT_WRITE_RD"     );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RD"   ,
				    dest,"out_MEMORY_OUT_NUM_REG_RD"   );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RD"      ,
				    dest,"out_MEMORY_OUT_DATA_RD"      );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_WRITE_RE"     ,
				    dest,"out_MEMORY_OUT_WRITE_RE"     );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NUM_REG_RE"   ,
				    dest,"out_MEMORY_OUT_NUM_REG_RE"   );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_DATA_RE"      ,
				    dest,"out_MEMORY_OUT_DATA_RE"      );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_EXCEPTION"    ,
				    dest,"out_MEMORY_OUT_EXCEPTION"    );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_NO_SEQUENCE"  ,
				    dest,"out_MEMORY_OUT_NO_SEQUENCE"  );
	       PORT_MAP(_component ,src , "in_EXECUTE_UNIT_OUT_"+toString(i)+"_ADDRESS"      ,
				    dest,"out_MEMORY_OUT_ADDRESS"      );
	     }
	 }

       // ~~~~~[ Interface "write_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_write_unit; i++)
	 {
	   dest = _name+"_write_unit_"+toString(i);
	   
#ifdef POSITION
	   _component->interface_map (src ,"write_unit_out_"+toString(i),
				      dest,"write_out");
#endif
	   
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_VAL"          ,
				dest, "in_WRITE_UNIT_IN_VAL"          );
	   PORT_MAP(_component ,src , "in_WRITE_UNIT_IN_"+toString(i)+"_ACK"          ,
				dest,"out_WRITE_UNIT_IN_ACK"          );
	   if (_param->_have_port_context_id)
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_CONTEXT_ID"   ,
				dest, "in_WRITE_UNIT_IN_CONTEXT_ID"   );
	   if (_param->_have_port_front_end_id)
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_FRONT_END_ID" ,
				dest, "in_WRITE_UNIT_IN_FRONT_END_ID" );
	   if (_param->_have_port_ooo_engine_id)
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_OOO_ENGINE_ID",
				dest, "in_WRITE_UNIT_IN_OOO_ENGINE_ID");
	   if (_param->_have_port_packet_id)
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_PACKET_ID"    ,
				dest, "in_WRITE_UNIT_IN_PACKET_ID"    );
// 	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_OPERATION"    ,
// 				dest, "in_WRITE_UNIT_IN_OPERATION"    );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_TYPE"         ,
				dest, "in_WRITE_UNIT_IN_TYPE"         );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_WRITE_RD"     ,
				dest, "in_WRITE_UNIT_IN_WRITE_RD"     );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_NUM_REG_RD"   ,
				dest, "in_WRITE_UNIT_IN_NUM_REG_RD"   );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_DATA_RD"      ,
				dest, "in_WRITE_UNIT_IN_DATA_RD"      );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_WRITE_RE"     ,
				dest, "in_WRITE_UNIT_IN_WRITE_RE"     );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_NUM_REG_RE"   ,
				dest, "in_WRITE_UNIT_IN_NUM_REG_RE"   );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_DATA_RE"      ,
				dest, "in_WRITE_UNIT_IN_DATA_RE"      );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_EXCEPTION"    ,
				dest, "in_WRITE_UNIT_IN_EXCEPTION"    );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_NO_SEQUENCE"  ,
				dest, "in_WRITE_UNIT_IN_NO_SEQUENCE"  );
	   PORT_MAP(_component ,src ,"out_WRITE_UNIT_IN_"+toString(i)+"_ADDRESS"      ,
				dest, "in_WRITE_UNIT_IN_ADDRESS"      );
	 }
     }
     
     _component->test_map();
     for (uint32_t i=0; i<_param->_nb_read_unit; i++)
       _component_read_unit [i]->_component->test_map();
     for (uint32_t i=0; i<_param->_nb_functionnal_unit; i++)
       _component_functionnal_unit [i]->_component->test_map();
     for (uint32_t i=0; i<_param->_nb_load_store_unit; i++)
       _component_load_store_unit [i]->_component->test_map();
     for (uint32_t i=0; i<_param->_nb_write_unit; i++)
       _component_write_unit [i]->_component->test_map();
     _component_read_unit_to_execution_unit->_component->test_map();
     _component_execution_unit_to_write_unit->_component->test_map();
     _component_register_unit->_component->test_map();

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Execute_loop,FUNCTION,"End");
  };

}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
