#ifndef TIME_H
#define TIME_H

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <string>
#include <iostream>
#include <sys/time.h>

class Time 
{
private : timeval time_begin;
// private : timeval time_end;
  
public  : Time ()
  {
    gettimeofday(&time_begin     ,NULL);
  };

public  : ~Time ()
  {
    std::cout << *this;
  };

public  : friend std::ostream& operator<< (std::ostream& output_stream,
					   const Time & x)
  {
    timeval time_end;
    
    gettimeofday(&time_end       ,NULL);
    
    uint32_t nb_cycles = static_cast<uint32_t>(sc_simulation_time());

    double average = static_cast<double>(nb_cycles) / static_cast<double>(time_end.tv_sec-x.time_begin.tv_sec+1);
    
    output_stream << "Timing : " << nb_cycles << " cycles \t(" << average << " cycles/s)" << std::endl;

    return output_stream;
  }
};

#endif
