/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    XML xml ("read_unit");

    xml.balise_open("read_unit");
    xml.singleton_begin("size_read_queue         "); xml.attribut("value",toString(_size_read_queue         )); xml.singleton_end();
    xml.singleton_begin("size_reservation_station"); xml.attribut("value",toString(_size_reservation_station)); xml.singleton_end();
    xml.singleton_begin("nb_context              "); xml.attribut("value",toString(_nb_context              )); xml.singleton_end();
    xml.singleton_begin("nb_front_end            "); xml.attribut("value",toString(_nb_front_end            )); xml.singleton_end();
    xml.singleton_begin("nb_ooo_engine           "); xml.attribut("value",toString(_nb_ooo_engine           )); xml.singleton_end();
    xml.singleton_begin("nb_packet               "); xml.attribut("value",toString(_nb_packet               )); xml.singleton_end();
    xml.singleton_begin("size_general_data       "); xml.attribut("value",toString(_size_general_data       )); xml.singleton_end();
    xml.singleton_begin("size_special_data       "); xml.attribut("value",toString(_size_special_data       )); xml.singleton_end();
    xml.singleton_begin("nb_general_register     "); xml.attribut("value",toString(_nb_general_register     )); xml.singleton_end();
    xml.singleton_begin("nb_special_register     "); xml.attribut("value",toString(_nb_special_register     )); xml.singleton_end();
    xml.singleton_begin("nb_gpr_write            "); xml.attribut("value",toString(_nb_gpr_write            )); xml.singleton_end();
    xml.singleton_begin("nb_spr_write            "); xml.attribut("value",toString(_nb_spr_write            )); xml.singleton_end();
    xml.singleton_begin("size_store_queue        "); xml.attribut("value",toString(_size_store_queue        )); xml.singleton_end();
    xml.singleton_begin("size_load_queue         "); xml.attribut("value",toString(_size_load_queue         )); xml.singleton_end();
    xml.singleton_begin("nb_inst_retire          "); xml.attribut("value",toString(_nb_inst_retire          )); xml.singleton_end();
    xml.singleton_begin("nb_bypass_write         "); xml.attribut("value",toString(_nb_bypass_write         )); xml.singleton_end();
    xml.singleton_begin("nb_bypass_memory        "); xml.attribut("value",toString(_nb_bypass_memory        )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Read_unit,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Read_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters & x)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Read_unit,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
