/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/SelfTest/include/test.h"

#define NB_PARAMS 13

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_("  * nb_read_unit                                         (uint32_t)\n"));
  err (_("  * nb_execute_unit                                      (uint32_t)\n"));
  err (_("  * nb_context                                           (uint32_t)\n"));
  err (_("  * nb_front_end                                         (uint32_t)\n"));
  err (_("  * nb_ooo_engine                                        (uint32_t)\n"));
  err (_("  * nb_packet                                            (uint32_t)\n"));
  err (_("  * size_general_data                                    (uint32_t)\n"));
  err (_("  * size_special_data                                    (uint32_t)\n"));
  err (_("  * nb_general_register                                  (uint32_t)\n"));
  err (_("  * nb_special_register                                  (uint32_t)\n"));
  err (_("  * size_store_queue                                     (uint32_t)\n"));
  err (_("  * size_load_queue                                      (uint32_t)\n"));
  err (_("  * priority                                             (uint32_t)\n"));
  err (_("  * table_routing        [nb_read_unit][nb_execute_unit] (bool    )\n"));
  err (_("  * table_execute_type   [nb_execute_unit][nb_type*]     (bool    )\n"));
  err (_("    * [TYPE_ALU    ]\n"));
  err (_("    * [TYPE_SHIFT  ]\n"));
  err (_("    * [TYPE_MOVE   ]\n"));
  err (_("    * [TYPE_TEST   ]\n"));
  err (_("    * [TYPE_MUL_DIV]\n"));
  err (_("    * [TYPE_EXTEND ]\n"));
  err (_("    * [TYPE_FIND   ]\n"));
  err (_("    * [TYPE_SPECIAL]\n"));
  err (_("    * [TYPE_CUSTOM ]\n"));
  err (_("    * [TYPE_BRANCH ]\n"));
  err (_("    * [TYPE_MEMORY ]\n"));
  err (_("  * table_execute_thread [nb_execute_unit][nb_thread]    (bool    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  string      name                  =      argv[x++];
  uint32_t    _nb_read_unit         = atoi(argv[x++]);
  uint32_t    _nb_execute_unit      = atoi(argv[x++]);
  uint32_t    _nb_context           = atoi(argv[x++]);
  uint32_t    _nb_front_end         = atoi(argv[x++]);
  uint32_t    _nb_ooo_engine        = atoi(argv[x++]);
  uint32_t    _nb_packet            = atoi(argv[x++]);
  uint32_t    _size_general_data    = atoi(argv[x++]);
  uint32_t    _size_special_data    = atoi(argv[x++]);
  uint32_t    _nb_general_register  = atoi(argv[x++]);
  uint32_t    _nb_special_register  = atoi(argv[x++]);
  uint32_t    _size_store_queue     = atoi(argv[x++]);
  uint32_t    _size_load_queue      = atoi(argv[x++]);
  Tpriority_t _priority             = fromString<Tpriority_t>(argv[x++]);

  uint32_t    _nb_thread            = get_nb_thread(_nb_context, _nb_front_end, _nb_ooo_engine);

  if (static_cast<uint32_t>(argc) != 2+NB_PARAMS+(_nb_read_unit*_nb_execute_unit)+(_nb_execute_unit*11)+(_nb_execute_unit*_nb_thread))
    usage (argc, argv);
  
  bool ** _table_routing        ;
  bool ** _table_execute_type   ;
  bool ** _table_execute_thread ;
  
  _table_routing = new bool * [_nb_read_unit];
  for (uint32_t i=0; i<_nb_read_unit; i++)
    {
      _table_routing [i] = new bool [_nb_execute_unit];
      for (uint32_t j=0; j<_nb_execute_unit; j++)
	_table_routing [i][j] = atoi(argv[x++]);
    }

  _table_execute_type = new bool * [_nb_execute_unit];
  for (uint32_t i=0; i<_nb_execute_unit; i++)
    {
      _table_execute_type [i] = new bool [MAX_TYPE];

      _table_execute_type [i][TYPE_ALU    ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_SHIFT  ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_MOVE   ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_TEST   ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_MUL_DIV] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_EXTEND ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_FIND   ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_SPECIAL] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_CUSTOM ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_BRANCH ] = atoi(argv[x++]);
      _table_execute_type [i][TYPE_MEMORY ] = atoi(argv[x++]);
    }

  _table_execute_thread = new bool * [_nb_execute_unit];
  for (uint32_t i=0; i<_nb_execute_unit; i++)
    {
      _table_execute_thread [i] = new bool [_nb_thread];

      for (uint32_t j=0; j<_nb_thread; j++)
	_table_execute_thread [i][j] = atoi(argv[x++]);
    }

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters
	(_nb_read_unit         ,
	 _nb_execute_unit      ,
	 _nb_context           ,
	 _nb_front_end         ,
	 _nb_ooo_engine        ,
	 _nb_packet            ,
	 _size_general_data    ,
	 _size_special_data    ,
	 _nb_general_register  ,
	 _nb_special_register  ,
	 _size_store_queue     ,
	 _size_load_queue      ,
	 _priority             ,
	 _table_routing        ,
	 _table_execute_type   ,
	 _table_execute_thread 
	 );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  delete [] _table_routing        ;
  delete [] _table_execute_type   ;
  delete [] _table_execute_thread ;

  return (EXIT_SUCCESS);
}

