/*
 * $Id: Parameters.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::Parameters"
  Parameters::Parameters (uint32_t size_queue                   ,
			  uint32_t nb_instruction               ,
			  uint32_t size_branch_update_prediction,
			  uint32_t size_general_data            )
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    _size_queue                            = size_queue                   ;
    _nb_instruction                        = nb_instruction               ;
    _size_branch_update_prediction         = size_branch_update_prediction;
    _size_general_data                     = size_general_data            ;

    _size_queue_ptr                        = log2(size_queue);
    _size_instruction_ptr                  = log2(nb_instruction);

    _have_port_queue_ptr                   = _size_queue_ptr > 0;
    _have_port_instruction_ptr             = _size_instruction_ptr > 0;
    _have_port_branch_update_prediction_id = size_branch_update_prediction > 0;
    
    test();
    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Ifetch_queue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Ifetch_queue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");
    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
