#ifdef SYSTEMC
/*
 * $Id: Meta_Predictor_Glue_genMealy_branch_complete_history.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"
#include "Common/include/BitManipulation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {

  void Meta_Predictor_Glue::genMealy_branch_complete_history (void)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_branch_complete_history","Begin");
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	Thistory_t     history = PORT_READ(in_BRANCH_COMPLETE_HISTORY [i]);

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_bht) 
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i], (history >> _param._shift_0) & gen_mask<Tbht_history_t>(_param._predictor_0_bht_size_shifter));
	if (_param._predictor_0_have_pht)
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i], (history >> _param._shift_1) & gen_mask<Tpht_history_t>(_param._predictor_0_pht_size_counter));
	  }

	if (_param._predictor_1_have_bht)
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i], (history >> _param._shift_2) & gen_mask<Tbht_history_t>(_param._predictor_1_bht_size_shifter));
	if (_param._predictor_1_have_pht)
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i], (history >> _param._shift_3) & gen_mask<Tpht_history_t>(_param._predictor_1_pht_size_counter));

	if (_param._predictor_2_have_bht)
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i], (history >> _param._shift_4) & gen_mask<Tbht_history_t>(_param._predictor_2_bht_size_shifter));
	if (_param._predictor_2_have_pht)
	PORT_WRITE(out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i], (history >> _param._shift_5) & gen_mask<Tpht_history_t>(_param._predictor_2_pht_size_counter));
      }

    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_branch_complete_history","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
