#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::genMealy_predict"
  void Update_Prediction_Table::genMealy_predict (void)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
    
    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
      {
	Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_PREDICT_CONTEXT_ID [i]):0;
	uint32_t   top     = reg_TOP[context];

// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"PREDICT [%d] (genMealy)",i);
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * context     : %d",context);
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * top         : %d",top);
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * state       : %s",toString(reg_UPDATE_PREDICTION_TABLE [context][top]._state).c_str());
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * is accurate : %d",PORT_READ(in_PREDICT_BTB_IS_ACCURATE [i]));
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * need update : %d",reg_NB_ELT_NEED_UPDATE [context]);

	// Not Full, accurate and no previous miss
	// Optimisation to restart faster :
	//   don't counter nb_elt_ko, but just nb_elt that need a update (change branch structure)
	internal_PREDICT_ACK [i] = ((reg_UPDATE_PREDICTION_TABLE [context][top]._state == UPDATE_PREDICTION_STATE_EMPTY) and
				    PORT_READ(in_PREDICT_BTB_IS_ACCURATE [i]) and
				    (reg_NB_ELT_NEED_UPDATE [context] == 0));

// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * ACK         : %d",internal_PREDICT_ACK [i]);

	PORT_WRITE(out_PREDICT_ACK [i], internal_PREDICT_ACK [i]);
      }

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
