/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/SelfTest/include/test.h"
#include "Behavioural/Custom/include/Custom_example.h"

#define NB_PARAMS 10

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_("  * nb_context          (uint32_t)\n"));
  err (_("  * nb_front_end        (uint32_t)\n"));
  err (_("  * nb_ooo_engine       (uint32_t)\n"));
  err (_("  * nb_packet           (uint32_t)\n"));
  err (_("  * size_general_data   (uint32_t)\n"));
  err (_("  * nb_general_register (uint32_t)\n"));
  err (_("  * size_special_data   (uint32_t)\n"));
  err (_("  * nb_special_register (uint32_t)\n"));
  err (_("  * size_store_queue    (uint32_t)\n"));
  err (_("  * size_load_queue     (uint32_t)\n"));
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t       x = 1;

  const string   name                =      argv[x++];
  const uint32_t nb_context          = atoi(argv[x++]);
  const uint32_t nb_front_end        = atoi(argv[x++]);
  const uint32_t nb_ooo_engine       = atoi(argv[x++]);
  const uint32_t nb_packet           = atoi(argv[x++]);
  const uint32_t size_general_data   = atoi(argv[x++]);
  const uint32_t nb_general_register = atoi(argv[x++]);
  const uint32_t size_special_data   = atoi(argv[x++]);
  const uint32_t nb_special_register = atoi(argv[x++]);
  const uint32_t size_store_queue    = atoi(argv[x++]);
  const uint32_t size_load_queue     = atoi(argv[x++]);

  execute_timing_t ** timing = new execute_timing_t * [MAX_TYPE];

  for (uint32_t i=0; i< MAX_TYPE; i++)
    {
      timing [i]= new execute_timing_t [MAX_OPERATION];
      
      for (uint32_t j=0; j< MAX_OPERATION; j++)
	timing[i][j]._delay = timing[i][j]._latence = 1;
    }

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters
	(nb_context          ,
	 nb_front_end        ,
	 nb_ooo_engine       ,
	 nb_packet           ,
	 size_general_data   ,
	 nb_general_register ,
	 size_special_data   ,
	 nb_special_register ,
	 size_store_queue    ,
	 size_load_queue     ,
	 timing              ,
	 &(morpheo::behavioural::custom::example_get_custom_information)
        );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> : %s.\n"),name.c_str(), error.what ());
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      exit (EXIT_FAILURE);
    }

  delete timing;
  
  return (EXIT_SUCCESS);
}

