#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Parameters_h

/*
 * $Id: Parameters.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Types.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/BitManipulation.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t            _size_store_queue             ;
  public : const uint32_t            _size_load_queue              ;
  public : const uint32_t            _size_speculative_access_queue;
  public : const uint32_t            _nb_port_check                ;
  public : const Tspeculative_load_t _speculative_load             ;
  public : const uint32_t            _nb_bypass_memory             ;
//public : const uint32_t            _nb_cache_port                ;
  public : const uint32_t            _nb_context                   ;
  public : const uint32_t            _nb_front_end                 ;
  public : const uint32_t            _nb_ooo_engine                ;
  public : const uint32_t            _nb_packet                    ;
  public : const uint32_t            _size_general_data            ;
  public : const uint32_t            _size_special_data            ;
  public : const uint32_t            _nb_general_register          ;
  public : const uint32_t            _nb_special_register          ;

  public : const uint32_t            _size_address_store_queue             ;
  public : const uint32_t            _size_address_load_queue              ;
  public : const uint32_t            _size_address_speculative_access_queue;
  public : const uint32_t            _size_context_id                      ;
  public : const uint32_t            _size_front_end_id                    ;
  public : const uint32_t            _size_ooo_engine_id                   ;
  public : const uint32_t            _size_packet_id                       ;
  public : const uint32_t            _size_general_register                ;
  public : const uint32_t            _size_special_register                ;
  public : const uint32_t            _size_dcache_context_id               ;
  public : const uint32_t            _size_dcache_packet_id                ;

  public : const bool                _have_port_context_id                 ;
  public : const bool                _have_port_front_end_id               ;
  public : const bool                _have_port_ooo_engine_id              ;
  public : const bool                _have_port_packet_id                  ;
  public : const bool                _have_port_dcache_context_id          ;
  public : const bool                _have_port_load_queue_ptr             ;

  public : const Tdcache_address_t   _mask_address_lsb                     ;
  public : const Tdcache_address_t   _mask_address_msb                     ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t            size_store_queue       ,
			uint32_t            size_load_queue        ,
			uint32_t            size_speculative_access_queue,
			uint32_t            nb_port_check          ,
			Tspeculative_load_t speculative_load       ,
			uint32_t            nb_bypass_memory       ,
			uint32_t            nb_context             ,
			uint32_t            nb_front_end           ,
			uint32_t            nb_ooo_engine          ,
			uint32_t            nb_packet              ,
			uint32_t            size_general_data      ,
			uint32_t            size_special_data      ,
			uint32_t            nb_general_register    ,
			uint32_t            nb_special_register    );

  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : Parameters_test msg_error (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters & x);
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
